/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.camel.runtime;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.serverless.workflow.WorkflowWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CamelCustomWorkItemHandler
extends WorkflowWorkItemHandler {
    public static final String OPERATION = "operation";
    public static final String NAME = "CamelCustomWorkItemHandler";
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelCustomWorkItemHandler.class);
    @Inject
    CamelContext context;
    @Inject
    ObjectMapper objectMapper;
    ProducerTemplate template;

    @PostConstruct
    void init() {
        this.template = this.context.createProducerTemplate();
    }

    @PreDestroy
    void stop() {
        if (this.template != null) {
            this.template.stop();
        }
    }

    protected Object internalExecute(KogitoWorkItem workItem, Map<String, Object> parameters) {
        Map metadata = workItem.getNodeInstance().getNode().getMetaData();
        String camelEndpoint = (String)metadata.get(OPERATION);
        this.checkEndpointExists(camelEndpoint);
        if (parameters.isEmpty()) {
            LOGGER.debug("Invoking Camel Endpoint '{}' with no body or headers", (Object)camelEndpoint);
            return this.template.requestBody(camelEndpoint, (Object)"");
        }
        Object body = parameters.getOrDefault("body", parameters.values().iterator().next());
        Map headers = (Map)this.objectMapper.convertValue(parameters.getOrDefault("headers", Collections.emptyMap()), (TypeReference)new TypeReference<Map<String, Object>>(){});
        LOGGER.debug("Invoking Camel Endpoint '{}' with body '{}' and headers '{}'", new Object[]{camelEndpoint, body, headers});
        return this.template.requestBodyAndHeaders(camelEndpoint, body, headers);
    }

    private void checkEndpointExists(String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Operation (the Camel Endpoint Identifier) is a mandatory parameter");
        }
        if (this.context.hasEndpoint(endpoint) == null) {
            throw new IllegalArgumentException("Endpoint '" + endpoint + "' doesn't exist. Make sure that the Camel Route is within the project's context.");
        }
    }

    public String getName() {
        return NAME;
    }
}

