/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointDiscovery;
import org.kie.kogito.addons.k8s.EndpointQueryKey;

public class LocalEndpointDiscovery
implements EndpointDiscovery {
    private Map<EndpointQueryKey, Endpoint> inMemoryCache = new HashMap<EndpointQueryKey, Endpoint>();

    @Override
    public Optional<Endpoint> findEndpoint(String namespace, String name) {
        EndpointQueryKey key = new EndpointQueryKey(namespace, name);
        if (this.inMemoryCache.containsKey(key)) {
            return Optional.of(this.inMemoryCache.get(key));
        }
        return Optional.empty();
    }

    @Override
    public List<Endpoint> findEndpoint(String namespace, Map<String, String> labels) {
        EndpointQueryKey key = new EndpointQueryKey(namespace, labels);
        if (this.inMemoryCache.containsKey(key)) {
            return Collections.singletonList(this.inMemoryCache.get(key));
        }
        return Collections.emptyList();
    }

    public void addCache(EndpointQueryKey key, Endpoint endpoint) {
        if (key == null || endpoint == null) {
            throw new IllegalArgumentException("Nor Key or Endpoint can be null");
        }
        this.inMemoryCache.put(key, endpoint);
    }
}

