/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.validation;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.validation.RecipientValidator;

@ApplicationScoped
public class RecipientValidatorProvider {
    private final List<RecipientValidator> validators;

    @Inject
    public RecipientValidatorProvider(Instance<RecipientValidator> validators) {
        this.validators = Stream.ofNullable(validators).flatMap(Instance::stream).collect(Collectors.toList());
    }

    public Optional<RecipientValidator> getValidator(Recipient<?> recipient) {
        return this.validators.stream().filter(validator -> validator.accept(recipient)).findFirst();
    }
}

