/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource;

import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.service.adapter.ScheduledJobAdapter;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;
import org.kie.kogito.jobs.service.validation.JobDetailsValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Path(value="/jobs")
public class JobResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobResource.class);
    @Inject
    TimerDelegateJobScheduler scheduler;
    @Inject
    ReactiveJobRepository jobRepository;
    @Inject
    JobDetailsValidator jobDetailsValidator;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(operationId="createJob")
    public Uni<ScheduledJob> create(Job job) {
        LOGGER.debug("REST create {}", (Object)job);
        JobDetails jobDetails = this.jobDetailsValidator.validateToCreate(ScheduledJobAdapter.to((ScheduledJob)ScheduledJob.builder().job(job).build()));
        return Uni.createFrom().publisher(this.scheduler.schedule(jobDetails)).onItem().ifNull().failWith((Throwable)new RuntimeException("Failed to schedule job " + job)).onItem().transform(ScheduledJobAdapter::of);
    }

    @PATCH
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(operationId="patchJob")
    public Uni<ScheduledJob> patch(@PathParam(value="id") String id, @RequestBody Job job) {
        LOGGER.debug("REST patch update {}", (Object)job);
        JobDetails jobToBeMerged = this.jobDetailsValidator.validateToMerge(ScheduledJobAdapter.to((ScheduledJob)ScheduledJob.ScheduledJobBuilder.from((Job)job)));
        return Uni.createFrom().publisher(this.scheduler.reschedule(id, jobToBeMerged.getTrigger()).buildRs()).onItem().ifNull().failWith((Throwable)new NotFoundException("Failed to reschedule job " + job)).onItem().transform(ScheduledJobAdapter::of);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(operationId="deleteJob")
    public Uni<ScheduledJob> delete(@PathParam(value="id") String id) {
        return Uni.createFrom().completionStage((CompletionStage)this.scheduler.cancel(id)).onItem().ifNull().failWith((Throwable)new NotFoundException("Failed to cancel job scheduling for jobId " + id)).onItem().transform(ScheduledJobAdapter::of);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(operationId="getJob")
    public Uni<ScheduledJob> get(@PathParam(value="id") String id) {
        return Uni.createFrom().completionStage(this.jobRepository.get(id)).onItem().ifNull().failWith((Throwable)new NotFoundException("Job not found id " + id)).onItem().transform(ScheduledJobAdapter::of);
    }
}

