/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.openapi;

import io.cloudevents.SpecVersion;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.kogito.jobs.service.api.RecipientDescriptor;
import org.kie.kogito.jobs.service.api.RecipientDescriptorRegistry;
import org.kie.kogito.jobs.service.api.ScheduleDescriptor;
import org.kie.kogito.jobs.service.api.ScheduleDescriptorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterForReflection
public class JobServiceModelFilter
implements OASFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobServiceModelFilter.class);
    static final String TYPE_PROPERTY_NAME = "type";
    static final String JSON_NODE_SCHEMA = "JsonNode";
    static final String SPEC_VERSION_SCHEMA = "SpecVersion";
    static final String SCHEDULE_SCHEMA = "Schedule";
    static final String RECIPIENT_SCHEMA = "Recipient";

    public void filterOpenAPI(OpenAPI openAPI) {
        Schema jsonObjectSchema = (Schema)openAPI.getComponents().getSchemas().get(JSON_NODE_SCHEMA);
        if (jsonObjectSchema != null) {
            LOGGER.debug("Setting {} schema type to: {}.", (Object)JSON_NODE_SCHEMA, (Object)Schema.SchemaType.OBJECT);
            jsonObjectSchema.type(Schema.SchemaType.OBJECT);
        } else {
            LOGGER.warn("{} schema type is not present it the OpenAPI document.", (Object)JSON_NODE_SCHEMA);
        }
        Schema specVersionSchema = (Schema)openAPI.getComponents().getSchemas().get(SPEC_VERSION_SCHEMA);
        if (specVersionSchema != null) {
            List<String> enumerationValues = Collections.unmodifiableList(Arrays.asList(SpecVersion.V03.toString(), SpecVersion.V1.toString()));
            LOGGER.debug("Changing {} enum schema from: {}, to: {}", new Object[]{SPEC_VERSION_SCHEMA, specVersionSchema.getEnumeration(), enumerationValues});
            specVersionSchema.enumeration(enumerationValues);
        } else {
            LOGGER.warn("{} enum schema is not present in the OpenAPI document.", (Object)SPEC_VERSION_SCHEMA);
        }
        Schema recipientSchema = (Schema)openAPI.getComponents().getSchemas().get(RECIPIENT_SCHEMA);
        if (recipientSchema != null) {
            this.adjustRecipientSchema(recipientSchema);
        } else {
            LOGGER.error("{} schema is not present in the OpenAPI document.", (Object)RECIPIENT_SCHEMA);
        }
        Schema scheduleSchema = (Schema)openAPI.getComponents().getSchemas().get(SCHEDULE_SCHEMA);
        if (scheduleSchema != null) {
            this.adjustScheduleSchema(scheduleSchema);
        } else {
            LOGGER.error("{} schema is not present in the OpenAPI document.", (Object)SCHEDULE_SCHEMA);
        }
    }

    private void adjustRecipientSchema(Schema schema) {
        LOGGER.debug("Processing Recipient implementations.");
        Discriminator discriminator = JobServiceModelFilter.addDiscriminator(schema, TYPE_PROPERTY_NAME);
        for (RecipientDescriptor descriptor : RecipientDescriptorRegistry.getInstance().getDescriptors()) {
            String ref = JobServiceModelFilter.buildLocalSchemaRef(descriptor.getType().getSimpleName());
            LOGGER.debug("Adding recipient mapping: {} -> {}", (Object)descriptor.getName(), (Object)ref);
            discriminator.addMapping(descriptor.getName(), ref);
        }
        schema.discriminator(discriminator);
        if (discriminator.getMapping() == null || discriminator.getMapping().isEmpty()) {
            LOGGER.error("No Recipients where found.");
        }
    }

    private void adjustScheduleSchema(Schema schema) {
        LOGGER.debug("Processing Schedule implementations.");
        Discriminator discriminator = JobServiceModelFilter.addDiscriminator(schema, TYPE_PROPERTY_NAME);
        for (ScheduleDescriptor descriptor : ScheduleDescriptorRegistry.getInstance().getDescriptors()) {
            String ref = JobServiceModelFilter.buildLocalSchemaRef(descriptor.getType().getSimpleName());
            LOGGER.debug("Adding schedule mapping: {} -> {}", (Object)descriptor.getName(), (Object)ref);
            discriminator.addMapping(descriptor.getName(), JobServiceModelFilter.buildLocalSchemaRef(descriptor.getType().getSimpleName()));
        }
        if (discriminator.getMapping() == null || discriminator.getMapping().isEmpty()) {
            LOGGER.error("No Schedules where found.");
        }
    }

    private static Discriminator addDiscriminator(Schema schema, String discriminatorProperty) {
        schema.addProperty(discriminatorProperty, OASFactory.createSchema().type(Schema.SchemaType.STRING));
        schema.discriminator(OASFactory.createDiscriminator().propertyName(discriminatorProperty));
        if (schema.getRequired() == null || !schema.getRequired().contains(discriminatorProperty)) {
            schema.addRequired(discriminatorProperty);
        }
        return schema.getDiscriminator();
    }

    private static String buildLocalSchemaRef(String name) {
        String template = "#/components/schemas/%s";
        return String.format(template, name);
    }
}

