/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.management;

import io.quarkus.vertx.web.RouteFilter;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.jobs.service.management.MessagingChangeEvent;

@ApplicationScoped
public class HttpGatekeeperFilter {
    public static final String ERROR_MESSAGE = "Job Service instance is not master";
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    @ConfigProperty(name="quarkus.smallrye-health.root-path", defaultValue="/q/health")
    private String healthCheckPath;

    protected void onMessagingStatusChange(@Observes MessagingChangeEvent event) {
        this.enabled.set(event.isEnabled());
    }

    @RouteFilter(value=100)
    void masterFilter(RoutingContext rc) throws Exception {
        if (!this.enabled.get() && !rc.request().path().contains(this.healthCheckPath)) {
            rc.response().setStatusCode(503);
            rc.response().setStatusMessage(ERROR_MESSAGE);
            rc.end();
            return;
        }
        rc.next();
    }
}

