/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.validation;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.api.PayloadData;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.validation.RecipientValidator;
import org.kie.kogito.jobs.service.validation.RecipientValidatorProvider;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class RecipientValidatorProviderTest {
    RecipientValidatorProviderTest() {
    }

    @Test
    void getValidator() {
        RecipientValidator1 validator1 = (RecipientValidator1)Mockito.mock(RecipientValidator1.class);
        ((RecipientValidator1)Mockito.doReturn((Object)true).when((Object)validator1)).accept((Recipient)ArgumentMatchers.any(Recipient1.class));
        RecipientValidator2 validator2 = (RecipientValidator2)Mockito.mock(RecipientValidator2.class);
        ((RecipientValidator2)Mockito.doReturn((Object)true).when((Object)validator2)).accept((Recipient)ArgumentMatchers.any(Recipient2.class));
        Instance validatorsInstance = (Instance)Mockito.mock(Instance.class);
        Stream<RecipientValidator> validators = Arrays.stream(new RecipientValidator[]{validator1, validator2});
        ((Instance)Mockito.doReturn(validators).when((Object)validatorsInstance)).stream();
        RecipientValidatorProvider provider = new RecipientValidatorProvider(validatorsInstance);
        Recipient1 recipient1 = new Recipient1();
        Recipient2 recipient2 = new Recipient2();
        ((OptionalAssert)Assertions.assertThat((Optional)provider.getValidator((Recipient)recipient1)).isNotEmpty()).hasValue((Object)validator1);
        ((OptionalAssert)Assertions.assertThat((Optional)provider.getValidator((Recipient)recipient2)).isNotEmpty()).hasValue((Object)validator2);
    }

    static class Recipient2
    extends Recipient {
        Recipient2() {
        }

        public PayloadData getPayload() {
            return null;
        }
    }

    static class Recipient1
    extends Recipient {
        Recipient1() {
        }

        public PayloadData getPayload() {
            return null;
        }
    }

    static interface RecipientValidator2
    extends RecipientValidator {
    }

    static interface RecipientValidator1
    extends RecipientValidator {
    }
}

