/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.validation;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.validation.RecipientInstanceValidator;
import org.kie.kogito.jobs.service.validation.RecipientValidatorProvider;
import org.kie.kogito.jobs.service.validation.RecipientValidatorProviderTest;
import org.kie.kogito.jobs.service.validation.ValidatorContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class RecipientInstanceValidatorTest {
    @Mock
    private RecipientValidatorProvider recipientValidatorProvider;
    @Mock
    private RecipientValidatorProviderTest.RecipientValidator1 validator1;
    @Mock
    private RecipientValidatorProviderTest.Recipient1 recipient1;
    @Mock
    private Recipient recipient;
    private RecipientInstanceValidator recipientInstanceValidator;

    RecipientInstanceValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.recipientInstanceValidator = new RecipientInstanceValidator(this.recipientValidatorProvider);
        ((RecipientValidatorProvider)Mockito.lenient().doReturn(Optional.of(this.validator1)).when((Object)this.recipientValidatorProvider)).getValidator((org.kie.kogito.jobs.service.api.Recipient)this.recipient1);
    }

    @Test
    void validateNull() {
        this.validateWithError(null, Recipient.class.getName());
    }

    @Test
    void validateNullRecipient() {
        ((Recipient)Mockito.doReturn(null).when((Object)this.recipient)).getRecipient();
        this.validateWithError(this.recipient, org.kie.kogito.jobs.service.api.Recipient.class + " instance can not be null");
    }

    @Test
    void validateSuccessful() {
        ((Recipient)Mockito.doReturn((Object)((Object)this.recipient1)).when((Object)this.recipient)).getRecipient();
        this.recipientInstanceValidator.validate(this.recipient);
        ((RecipientValidatorProviderTest.RecipientValidator1)Mockito.verify((Object)this.validator1)).validate((org.kie.kogito.jobs.service.api.Recipient)Mockito.eq((Object)((Object)this.recipient1)), (ValidatorContext)Mockito.any());
    }

    @Test
    void validateUnSuccessful() {
        String error = "Validation has failed!";
        ((RecipientValidatorProviderTest.RecipientValidator1)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(error)}).when((Object)this.validator1)).validate((org.kie.kogito.jobs.service.api.Recipient)Mockito.eq((Object)((Object)this.recipient1)), (ValidatorContext)Mockito.any());
        ((Recipient)Mockito.doReturn((Object)((Object)this.recipient1)).when((Object)this.recipient)).getRecipient();
        this.validateWithError(this.recipient, error);
        ((RecipientValidatorProviderTest.RecipientValidator1)Mockito.verify((Object)this.validator1)).validate((org.kie.kogito.jobs.service.api.Recipient)Mockito.eq((Object)((Object)this.recipient1)), (ValidatorContext)Mockito.any());
    }

    private void validateWithError(Recipient recipient, String expectedMessage) {
        Assertions.assertThatThrownBy(() -> this.recipientInstanceValidator.validate(recipient)).hasMessageStartingWith(expectedMessage);
    }
}

