/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.validation;

import java.time.OffsetDateTime;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.kie.kogito.jobs.service.validation.JobValidator;
import org.kie.kogito.jobs.service.validation.RecipientValidator;
import org.kie.kogito.jobs.service.validation.RecipientValidatorProvider;
import org.kie.kogito.jobs.service.validation.ValidatorContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class JobValidatorTest {
    private static final String JOB_ID = "JOB_ID";
    private static final String CORRELATION_ID = "CORRELATION_IDB_ID";
    private static final OffsetDateTime START_TIME = OffsetDateTime.parse("2023-03-23T15:20:25.001+01:00");
    private static final int REPEAT_COUNT = 2;
    private static final long DELAY = 4L;
    private static final TemporalUnit DELAY_UNIT = TemporalUnit.MINUTES;
    private static final long EXECUTION_TIMEOUT = 5L;
    private static final TemporalUnit EXECUTION_TIMEOUT_UNIT = TemporalUnit.SECONDS;
    private static final String RECIPIENT_VALIDATION_ERROR = "The recipient validation has failed!";
    private Job job;
    private Recipient recipient;
    private JobValidator validator;
    private RecipientValidatorProvider recipientValidatorProvider;

    JobValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.recipientValidatorProvider = (RecipientValidatorProvider)Mockito.mock(RecipientValidatorProvider.class);
        ((RecipientValidatorProvider)Mockito.doReturn(Optional.empty()).when((Object)this.recipientValidatorProvider)).getValidator((Recipient)ArgumentMatchers.any());
        this.validator = new JobValidator(this.recipientValidatorProvider);
        this.recipient = (Recipient)Mockito.mock(Recipient.class);
        this.job = Job.builder().id(JOB_ID).correlationId(CORRELATION_ID).schedule((Schedule)TimerSchedule.builder().startTime(START_TIME).repeatCount(Integer.valueOf(2)).delay(Long.valueOf(4L)).delayUnit(DELAY_UNIT).build()).recipient(this.recipient).executionTimeout(Long.valueOf(5L)).executionTimeoutUnit(EXECUTION_TIMEOUT_UNIT).build();
    }

    @Test
    void validateToCreateSuccessful() {
        this.validator.validateToCreate(this.job);
    }

    @Test
    void validateToCreateWithNullId() {
        this.job.setId(null);
        this.validateToCreateWithError(this.job, "A non empty id");
    }

    @Test
    void validateToCreateWithNullCorrelationId() {
        this.job.setCorrelationId(null);
        this.validateToCreateWithError(this.job, "A non empty correlationId");
    }

    @Test
    void validateToCreateWithNullSchedule() {
        this.job.setSchedule(null);
        this.validateToCreateWithError(this.job, "A non null Schedule");
    }

    @Test
    void validateToCreateWithNoTimerSchedule() {
        this.job.setSchedule((Schedule)Mockito.mock(Schedule.class));
        this.validateToCreateWithError(this.job, "Only the TimerSchedule");
    }

    @Test
    void validateToCreateWithTimerScheduleStartTimeNull() {
        ((TimerSchedule)this.job.getSchedule()).setStartTime(null);
        this.validateToCreateWithError(this.job, "A non null startTime must");
    }

    @Test
    void validateToCreateWithTimerScheduleNegativeRepeatCount() {
        ((TimerSchedule)this.job.getSchedule()).setRepeatCount(Integer.valueOf(-1));
        this.validateToCreateWithError(this.job, "A negative repeatCount");
    }

    @Test
    void validateToCreateWithTimerScheduleNegativeDelay() {
        ((TimerSchedule)this.job.getSchedule()).setDelay(Long.valueOf(-1L));
        this.validateToCreateWithError(this.job, "A negative delay");
    }

    @Test
    void validateToCreateWithNullRecipient() {
        this.job.setRecipient(null);
        this.validateToCreateWithError(this.job, "A non null Recipient");
    }

    @Test
    void validateToCreateWithRecipientError() {
        RecipientValidator recipientValidator = (RecipientValidator)Mockito.mock(RecipientValidator.class);
        ((RecipientValidatorProvider)Mockito.doReturn(Optional.of(recipientValidator)).when((Object)this.recipientValidatorProvider)).getValidator(this.recipient);
        ((RecipientValidator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(RECIPIENT_VALIDATION_ERROR)}).when((Object)recipientValidator)).validate((Recipient)Mockito.eq((Object)this.recipient), (ValidatorContext)ArgumentMatchers.any());
        this.validateToCreateWithError(this.job, RECIPIENT_VALIDATION_ERROR);
    }

    @Test
    void validateToCreateWithNegativeExecutionTimeout() {
        this.job.setExecutionTimeout(Long.valueOf(-1L));
        this.validateToCreateWithError(this.job, "Job executionTimeout can not be negative");
    }

    private void validateToCreateWithError(Job job, String expectedMessage) {
        Assertions.assertThatThrownBy(() -> this.validator.validateToCreate(job)).hasMessageStartingWith(expectedMessage);
    }
}

