/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.scheduler.impl;

import io.smallrye.mutiny.Multi;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.job.DelegateJob;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobDetailsContext;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.model.ManageableJobHandle;
import org.kie.kogito.jobs.service.scheduler.BaseTimerJobScheduler;
import org.kie.kogito.jobs.service.scheduler.BaseTimerJobSchedulerTest;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;
import org.kie.kogito.jobs.service.scheduler.impl.VertxTimerServiceScheduler;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Job;
import org.kie.kogito.timer.JobContext;
import org.kie.kogito.timer.Trigger;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Publisher;

@ExtendWith(value={MockitoExtension.class})
class TimerDelegateJobSchedulerTest
extends BaseTimerJobSchedulerTest {
    @Spy
    @InjectMocks
    private TimerDelegateJobScheduler tested;
    @Mock
    private VertxTimerServiceScheduler timer;

    TimerDelegateJobSchedulerTest() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        ManageableJobHandle handle = new ManageableJobHandle("3");
        handle.setScheduledTime(DateUtil.now());
        Mockito.lenient().when((Object)this.timer.scheduleJob((Job)ArgumentMatchers.any(Job.class), (JobContext)ArgumentMatchers.any(JobContext.class), (Trigger)ArgumentMatchers.any(Trigger.class))).thenReturn((Object)handle);
    }

    @Override
    public BaseTimerJobScheduler tested() {
        return this.tested;
    }

    @Test
    void testDoSchedule() {
        PublisherBuilder schedule = this.tested.doSchedule(this.scheduledJob, Optional.empty());
        Multi.createFrom().publisher(schedule.buildRs()).subscribe().with(this.dummyCallback(), this.dummyCallback());
        ((VertxTimerServiceScheduler)Mockito.verify((Object)this.timer)).scheduleJob((Job)ArgumentMatchers.any(DelegateJob.class), (JobContext)ArgumentMatchers.any(JobDetailsContext.class), (Trigger)ArgumentMatchers.eq((Object)this.scheduledJob.getTrigger()));
    }

    @Test
    void testDoCancel() {
        Publisher cancel = this.tested.doCancel(JobDetails.builder().of(this.scheduledJob).scheduledId("3").build());
        Multi.createFrom().publisher(cancel).subscribe().with(this.dummyCallback(), this.dummyCallback());
        ((VertxTimerServiceScheduler)Mockito.verify((Object)this.timer)).removeJob((ManageableJobHandle)ArgumentMatchers.any(ManageableJobHandle.class));
    }

    @Test
    void testDoCancelNullId() {
        Publisher cancel = this.tested.doCancel(JobDetails.builder().of(this.scheduledJob).scheduledId(null).build());
        Multi.createFrom().publisher(cancel).subscribe().with(this.dummyCallback(), this.dummyCallback());
        ((VertxTimerServiceScheduler)Mockito.verify((Object)this.timer, (VerificationMode)Mockito.never())).removeJob((ManageableJobHandle)ArgumentMatchers.any(ManageableJobHandle.class));
    }

    @Test
    void testJobSuccessProcessor() {
        JobExecutionResponse response = this.getJobResponse();
        ((TimerDelegateJobScheduler)Mockito.doReturn((Object)ReactiveStreams.of((Object)JobDetails.builder().build())).when((Object)this.tested)).handleJobExecutionSuccess(response);
        this.tested.jobSuccessProcessor(response).thenAccept(r -> Assertions.assertThat((Boolean)r).isTrue());
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.tested)).handleJobExecutionSuccess(response);
    }

    @Test
    void testJobSuccessProcessorFail() {
        JobExecutionResponse response = this.getJobResponse();
        ((TimerDelegateJobScheduler)Mockito.doReturn((Object)ReactiveStreams.failed((Throwable)new RuntimeException())).when((Object)this.tested)).handleJobExecutionSuccess(response);
        this.tested.jobSuccessProcessor(response).thenAccept(r -> Assertions.assertThat((Boolean)r).isFalse());
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.tested)).handleJobExecutionSuccess(response);
    }

    @Test
    void testJobErrorProcessor() {
        JobExecutionResponse response = this.getJobResponse();
        ((TimerDelegateJobScheduler)Mockito.doReturn((Object)ReactiveStreams.of((Object)JobDetails.builder().build())).when((Object)this.tested)).handleJobExecutionError(response);
        this.tested.jobErrorProcessor(response).thenAccept(r -> Assertions.assertThat((Boolean)r).isTrue());
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.tested)).handleJobExecutionError(response);
    }

    @Test
    void testJobErrorProcessorFail() {
        JobExecutionResponse response = this.getJobResponse();
        ((TimerDelegateJobScheduler)Mockito.doReturn((Object)ReactiveStreams.failed((Throwable)new RuntimeException())).when((Object)this.tested)).handleJobExecutionError(response);
        this.tested.jobErrorProcessor(response).thenAccept(r -> Assertions.assertThat((Boolean)r).isFalse());
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.tested)).handleJobExecutionError(response);
    }

    private JobExecutionResponse getJobResponse() {
        return JobExecutionResponse.builder().jobId(UUID.randomUUID().toString()).message("Processing job").code("123").now().build();
    }
}

