/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.v2.sink.recipient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.tomakehurst.wiremock.WireMockServer;
import io.cloudevents.SpecVersion;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.TestUtils;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipient;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientPayloadData;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.kie.kogito.jobs.service.health.HealthCheckUtils;
import org.kie.kogito.jobs.service.resource.v2.ExternalResourcesMock;

public abstract class BaseSinkRecipientPayloadTypesTest
implements ExternalResourcesMock.ExternalResourcesMockAware {
    public static final String EXTERNAL_RESOURCE_FOR_BINARY_MODE_JSON_PAYLOAD = "/external-resource/sink-recipient-binary-mode-json-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_BINARY_MODE_BINARY_PAYLOAD = "/external-resource/sink-recipient-binary-mode-binary-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_STRUCTURED_MODE_JSON_PAYLOAD = "/external-resource/sink-recipient-structured-mode-json-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_STRUCTURED_MODE_BINARY_PAYLOAD = "/external-resource/sink-recipient-structured-mode-binary-payload-data";
    public static final String SINK_BINARY_MODE_JSON_JOB_ID = "SINK_BINARY_MODE_JSON_JOB_ID";
    public static final String SINK_BINARY_MODE_BINARY_JOB_ID = "SINK_BINARY_MODE_BINARY_JOB_ID";
    public static final String SINK_STRUCTURED_MODE_JSON_JOB_ID = "SINK_STRUCTURED_MODE_JSON_JOB_ID";
    public static final String SINK_STRUCTURED_MODE_BINARY_JOB_ID = "SINK_STRUCTURED_MODE_BINARY_JOB_ID";
    public static final String SINK_CE_TYPE = "SINK_CE_TYPE";
    public static final SpecVersion SINK_CE_SPECVERSION = SpecVersion.V1;
    public static final URI SINK_CE_SOURCE = URI.create("http://SINK_CE_SOURCE");
    public static final String SINK_CE_SUBJECT = "SINK_CE_SUBJECT";
    public static final String SINK_CE_DATACONTENTTYPE = "SINK_CE_DATACONTENTTYPE";
    public static final URI SINK_CE_DATASCHEMA = URI.create("http://SINK_CE_DATASCHEMA");
    public static final String SINK_EXTENSION_1_NAME = "sinkextension1name";
    public static final String SINK_EXTENSION_1_VALUE = "SINK_EXTENSION_1_VALUE";
    public static final String SINK_EXTENSION_2_NAME = "sinkextension2name";
    public static final String SINK_EXTENSION_2_VALUE = "SINK_EXTENSION_2_VALUE";
    public static final String SINK_PROPERTY_1 = "PROPERTY_1";
    public static final String SINK_PROPERTY_1_VALUE = "PROPERTY_1_VALUE";
    public static final byte[] SINK_BINARY_VALUE = "Arbitrary bytes sent to the sink recipient".getBytes();
    protected WireMockServer externalResourcesServer;
    protected String externalResourcesServerURL;
    @Inject
    protected ObjectMapper objectMapper;

    @BeforeEach
    void setUp() {
        HealthCheckUtils.awaitReadyHealthCheck(1, TimeUnit.MINUTES);
    }

    @Override
    public void setExternalResourcesServer(WireMockServer externalResourcesServer) {
        this.externalResourcesServer = externalResourcesServer;
        this.externalResourcesServerURL = externalResourcesServer.baseUrl();
    }

    @Test
    void sinkRecipientBinaryModeWithJsonPayloadData() throws Exception {
        ObjectNode payload = this.objectMapper.createObjectNode().put(SINK_PROPERTY_1, SINK_PROPERTY_1_VALUE);
        SinkRecipient sinkRecipient = SinkRecipient.builder().forJsonPayload().payload((SinkRecipientPayloadData)SinkRecipientJsonPayloadData.from((JsonNode)payload)).sinkUrl(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_BINARY_MODE_JSON_PAYLOAD).contentMode(SinkRecipient.ContentMode.BINARY).build();
        BaseSinkRecipientPayloadTypesTest.applyCommonValues(sinkRecipient);
        Job job = Job.builder().id(SINK_BINARY_MODE_JSON_JOB_ID).correlationId(SINK_BINARY_MODE_JSON_JOB_ID).recipient((Recipient)sinkRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        BaseSinkRecipientPayloadTypesTest.executeSinkRecipientJob(job);
    }

    @Test
    void sinkRecipientBinaryModeWithBinaryPayloadData() throws Exception {
        SinkRecipient sinkRecipient = SinkRecipient.builder().forBinaryPayload().payload((SinkRecipientPayloadData)SinkRecipientBinaryPayloadData.from((byte[])SINK_BINARY_VALUE)).sinkUrl(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_BINARY_MODE_BINARY_PAYLOAD).contentMode(SinkRecipient.ContentMode.BINARY).build();
        BaseSinkRecipientPayloadTypesTest.applyCommonValues(sinkRecipient);
        Job job = Job.builder().id(SINK_BINARY_MODE_BINARY_JOB_ID).correlationId(SINK_BINARY_MODE_BINARY_JOB_ID).recipient((Recipient)sinkRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        BaseSinkRecipientPayloadTypesTest.executeSinkRecipientJob(job);
    }

    @Test
    void sinkRecipientStructuredModeWithJsonPayloadData() throws Exception {
        ObjectNode payload = this.objectMapper.createObjectNode().put(SINK_PROPERTY_1, SINK_PROPERTY_1_VALUE);
        SinkRecipient sinkRecipient = SinkRecipient.builder().forJsonPayload().payload((SinkRecipientPayloadData)SinkRecipientJsonPayloadData.from((JsonNode)payload)).sinkUrl(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_STRUCTURED_MODE_JSON_PAYLOAD).contentMode(SinkRecipient.ContentMode.STRUCTURED).build();
        BaseSinkRecipientPayloadTypesTest.applyCommonValues(sinkRecipient);
        Job job = Job.builder().id(SINK_STRUCTURED_MODE_JSON_JOB_ID).correlationId(SINK_STRUCTURED_MODE_JSON_JOB_ID).recipient((Recipient)sinkRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        BaseSinkRecipientPayloadTypesTest.executeSinkRecipientJob(job);
    }

    @Test
    void sinkRecipientStructuredModeWithBinaryPayloadData() throws Exception {
        SinkRecipient sinkRecipient = SinkRecipient.builder().forBinaryPayload().payload((SinkRecipientPayloadData)SinkRecipientBinaryPayloadData.from((byte[])SINK_BINARY_VALUE)).sinkUrl(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_STRUCTURED_MODE_BINARY_PAYLOAD).contentMode(SinkRecipient.ContentMode.STRUCTURED).build();
        BaseSinkRecipientPayloadTypesTest.applyCommonValues(sinkRecipient);
        Job job = Job.builder().id(SINK_STRUCTURED_MODE_BINARY_JOB_ID).correlationId(SINK_STRUCTURED_MODE_BINARY_JOB_ID).recipient((Recipient)sinkRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        BaseSinkRecipientPayloadTypesTest.executeSinkRecipientJob(job);
    }

    private static void executeSinkRecipientJob(Job job) throws Exception {
        Job createdJob = TestUtils.createJobV2(job);
        Assertions.assertThat((Object)createdJob).isNotNull();
        TestUtils.assertJobHasFinishedV2(job.getId(), 60L);
    }

    private static void applyCommonValues(SinkRecipient<?> recipient) {
        recipient.setCeSpecVersion(SINK_CE_SPECVERSION);
        recipient.setCeType(SINK_CE_TYPE);
        recipient.setCeDataSchema(SINK_CE_DATASCHEMA);
        recipient.setCeDataContentType(SINK_CE_DATACONTENTTYPE);
        recipient.setCeSource(SINK_CE_SOURCE);
        recipient.setCeSubject(SINK_CE_SUBJECT);
        recipient.addCeExtension(SINK_EXTENSION_1_NAME, (Object)SINK_EXTENSION_1_VALUE);
        recipient.addCeExtension(SINK_EXTENSION_2_NAME, (Object)SINK_EXTENSION_2_VALUE);
    }
}

