/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.v2.http.recipient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.tomakehurst.wiremock.WireMockServer;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.TestUtils;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientStringPayloadData;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.kie.kogito.jobs.service.health.HealthCheckUtils;
import org.kie.kogito.jobs.service.resource.v2.ExternalResourcesMock;

public abstract class BaseHttpRecipientPayloadTypesTest
implements ExternalResourcesMock.ExternalResourcesMockAware {
    public static final String EXTERNAL_RESOURCE_FOR_JSON_PAYLOAD = "/external-resource/http-recipient-json-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_STRING_PAYLOAD = "/external-resource/http-recipient-string-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_BINARY_PAYLOAD = "/external-resource/http-recipient-binary-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_CUSTOM_TIMEOUT = "/external-resource/http-recipient-custom-timeout";
    public static final String HTTP_JSON_JOB_ID = "HTTP_JSON_JOB_ID";
    public static final String HTTP_STRING_JOB_ID = "HTTP_STRING_JOB_ID";
    public static final String HTTP_BINARY_JOB_ID = "HTTP_BINARY_JOB_ID";
    public static final String HTTP_JOB_WITH_CUSTOM_TIMEOUT_ID = "HTTP_JOB_WITH_CUSTOM_TIMEOUT_ID";
    public static final String HTTP_HEADER_1 = "HTTP_HEADER_1";
    public static final String HTTP_HEADER_1_VALUE = "HTTP_HEADER_1_VALUE";
    public static final String HTTP_HEADER_2 = "HTTP_HEADER_2";
    public static final String HTTP_HEADER_2_VALUE = "HTTP_HEADER_2_VALUE";
    public static final String HTTP_QUERY_PARAM_1 = "HTTP_QUERY_PARAM_1";
    public static final String HTTP_QUERY_PARAM_1_VALUE = "HTTP_QUERY_PARAM_1_VALUE";
    public static final String HTTP_PROPERTY_1 = "HTTP_PROPERTY_1";
    public static final String HTTP_PROPERTY_1_VALUE = "HTTP_PROPERTY_1_VALUE";
    public static final String HTTP_TEXT_PLAIN_VALUE = "Plain text sent to the recipient";
    public static final byte[] HTTP_BINARY_VALUE = "Arbitrary bytes sent to the http recipient".getBytes();
    public static final Long EXECUTION_TIMEOUT = 2L;
    public static final TemporalUnit EXECUTION_TIMEOUT_UNIT = TemporalUnit.SECONDS;
    protected WireMockServer externalResourcesServer;
    protected String externalResourcesServerURL;
    @Inject
    protected ObjectMapper objectMapper;

    @BeforeEach
    void setUp() {
        HealthCheckUtils.awaitReadyHealthCheck(1, TimeUnit.MINUTES);
    }

    @Override
    public void setExternalResourcesServer(WireMockServer externalResourcesServer) {
        this.externalResourcesServer = externalResourcesServer;
        this.externalResourcesServerURL = externalResourcesServer.baseUrl();
    }

    @Test
    void httpRecipientWithJsonPayloadData() throws Exception {
        ObjectNode payload = this.objectMapper.createObjectNode().put(HTTP_PROPERTY_1, HTTP_PROPERTY_1_VALUE);
        HttpRecipient httpRecipient = HttpRecipient.builder().forJsonPayload().payload((HttpRecipientPayloadData)HttpRecipientJsonPayloadData.from((JsonNode)payload)).header("Content-Type", "application/json").url(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_JSON_PAYLOAD).build();
        BaseHttpRecipientPayloadTypesTest.applyCommonValues(httpRecipient);
        Job job = Job.builder().id(HTTP_JSON_JOB_ID).correlationId(HTTP_JSON_JOB_ID).recipient((Recipient)httpRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        this.executeHttpRecipientJob(job);
    }

    @Test
    void httpRecipientWithStringPayloadData() throws Exception {
        HttpRecipient httpRecipient = HttpRecipient.builder().forStringPayload().payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)HTTP_TEXT_PLAIN_VALUE)).header("Content-Type", "text/plain").url(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_STRING_PAYLOAD).build();
        BaseHttpRecipientPayloadTypesTest.applyCommonValues(httpRecipient);
        Job job = Job.builder().id(HTTP_STRING_JOB_ID).correlationId(HTTP_STRING_JOB_ID).recipient((Recipient)httpRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        this.executeHttpRecipientJob(job);
    }

    @Test
    void httpRecipientWithBinaryPayloadData() throws Exception {
        HttpRecipient httpRecipient = HttpRecipient.builder().forBinaryPayload().payload((HttpRecipientPayloadData)HttpRecipientBinaryPayloadData.from((byte[])HTTP_BINARY_VALUE)).header("Content-Type", "application/octet-stream").url(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_BINARY_PAYLOAD).build();
        BaseHttpRecipientPayloadTypesTest.applyCommonValues(httpRecipient);
        Job job = Job.builder().id(HTTP_BINARY_JOB_ID).correlationId(HTTP_BINARY_JOB_ID).recipient((Recipient)httpRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        this.executeHttpRecipientJob(job);
    }

    @Test
    void httpRecipientWithCustomTimeout() throws Exception {
        HttpRecipient httpRecipient = HttpRecipient.builder().forStringPayload().payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)HTTP_TEXT_PLAIN_VALUE)).header("Content-Type", "text/plain").url(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_CUSTOM_TIMEOUT).build();
        BaseHttpRecipientPayloadTypesTest.applyCommonValues(httpRecipient);
        Job job = Job.builder().id(HTTP_JOB_WITH_CUSTOM_TIMEOUT_ID).correlationId(HTTP_JOB_WITH_CUSTOM_TIMEOUT_ID).recipient((Recipient)httpRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).executionTimeout(EXECUTION_TIMEOUT).executionTimeoutUnit(EXECUTION_TIMEOUT_UNIT).build();
        Job createdJob = this.executeHttpRecipientJob(job);
        Assertions.assertThat((Long)createdJob.getExecutionTimeout()).isEqualTo((Object)EXECUTION_TIMEOUT);
        Assertions.assertThat((Comparable)createdJob.getExecutionTimeoutUnit()).isEqualTo((Object)EXECUTION_TIMEOUT_UNIT);
    }

    private Job executeHttpRecipientJob(Job job) throws Exception {
        Job createdJob = TestUtils.createJobV2(job);
        Assertions.assertThat((Object)createdJob).isNotNull();
        TestUtils.assertJobHasFinishedV2(job.getId(), 60L);
        return job;
    }

    private static void applyCommonValues(HttpRecipient<?> recipient) {
        recipient.addHeader(HTTP_HEADER_1, HTTP_HEADER_1_VALUE);
        recipient.addHeader(HTTP_HEADER_2, HTTP_HEADER_2_VALUE);
        recipient.addQueryParam(HTTP_QUERY_PARAM_1, HTTP_QUERY_PARAM_1_VALUE);
        recipient.setMethod("POST");
    }
}

