/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.v2;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.kie.kogito.jobs.service.resource.v2.http.recipient.BaseHttpRecipientPayloadTypesTest;
import org.kie.kogito.jobs.service.resource.v2.sink.recipient.BaseSinkRecipientPayloadTypesTest;

public class ExternalResourcesMock
implements QuarkusTestResourceLifecycleManager {
    private WireMockServer wireMockServer;
    private String baseUrl;
    public static final String EXTERNAL_RESOURCES_MOCK_URL = "external-resources-mock.url";
    private static final String LIMIT_QUERY_PARAM = "limit";
    private static final String LIMIT_QUERY_PARAM_VALUE = "0";

    public Map<String, String> start() {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort());
        this.wireMockServer.start();
        WireMock.configureFor((int)this.wireMockServer.port());
        this.setUpBaseHttpRecipientPayloadTypesIT();
        this.setUpBaseSinkRecipientPayloadTypesIT();
        this.baseUrl = this.wireMockServer.baseUrl();
        return Collections.singletonMap(EXTERNAL_RESOURCES_MOCK_URL, this.baseUrl);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void stop() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    public void inject(Object testInstance) {
        if (testInstance instanceof ExternalResourcesMockAware) {
            ((ExternalResourcesMockAware)testInstance).setExternalResourcesServer(this.wireMockServer);
        }
    }

    private void setUpBaseHttpRecipientPayloadTypesIT() {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)new UrlPathPattern(WireMock.equalTo((String)"/external-resource/http-recipient-json-payload-data"), false)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("HTTP_HEADER_1", WireMock.equalTo((String)"HTTP_HEADER_1_VALUE")).withHeader("HTTP_HEADER_2", WireMock.equalTo((String)"HTTP_HEADER_2_VALUE")).withQueryParam("HTTP_QUERY_PARAM_1", WireMock.equalTo((String)"HTTP_QUERY_PARAM_1_VALUE")).withQueryParam(LIMIT_QUERY_PARAM, WireMock.equalTo((String)LIMIT_QUERY_PARAM_VALUE)).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"HTTP_PROPERTY_1\" : \"HTTP_PROPERTY_1_VALUE\"}")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)new UrlPathPattern(WireMock.equalTo((String)"/external-resource/http-recipient-string-payload-data"), false)).withHeader("Content-Type", WireMock.equalTo((String)"text/plain")).withHeader("HTTP_HEADER_1", WireMock.equalTo((String)"HTTP_HEADER_1_VALUE")).withHeader("HTTP_HEADER_2", WireMock.equalTo((String)"HTTP_HEADER_2_VALUE")).withQueryParam("HTTP_QUERY_PARAM_1", WireMock.equalTo((String)"HTTP_QUERY_PARAM_1_VALUE")).withQueryParam(LIMIT_QUERY_PARAM, WireMock.equalTo((String)LIMIT_QUERY_PARAM_VALUE)).withRequestBody((ContentPattern)WireMock.equalTo((String)"Plain text sent to the recipient")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)new UrlPathPattern(WireMock.equalTo((String)"/external-resource/http-recipient-binary-payload-data"), false)).withHeader("Content-Type", WireMock.equalTo((String)"application/octet-stream")).withHeader("HTTP_HEADER_1", WireMock.equalTo((String)"HTTP_HEADER_1_VALUE")).withHeader("HTTP_HEADER_2", WireMock.equalTo((String)"HTTP_HEADER_2_VALUE")).withQueryParam("HTTP_QUERY_PARAM_1", WireMock.equalTo((String)"HTTP_QUERY_PARAM_1_VALUE")).withQueryParam(LIMIT_QUERY_PARAM, WireMock.equalTo((String)LIMIT_QUERY_PARAM_VALUE)).withRequestBody((ContentPattern)new BinaryEqualToPattern(BaseHttpRecipientPayloadTypesTest.HTTP_BINARY_VALUE)).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)new UrlPathPattern(WireMock.equalTo((String)"/external-resource/http-recipient-custom-timeout"), false)).withHeader("Content-Type", WireMock.equalTo((String)"text/plain")).withQueryParam(LIMIT_QUERY_PARAM, WireMock.equalTo((String)LIMIT_QUERY_PARAM_VALUE)).withRequestBody((ContentPattern)WireMock.equalTo((String)"Plain text sent to the recipient")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
    }

    private void setUpBaseSinkRecipientPayloadTypesIT() {
        WireMock.stubFor((MappingBuilder)ExternalResourcesMock.applySinkRecipientBinaryModeCommonMappings(WireMock.post((String)"/external-resource/sink-recipient-binary-mode-json-payload-data")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"PROPERTY_1\" : \"PROPERTY_1_VALUE\"}")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)ExternalResourcesMock.applySinkRecipientBinaryModeCommonMappings(WireMock.post((String)"/external-resource/sink-recipient-binary-mode-binary-payload-data")).withRequestBody((ContentPattern)new BinaryEqualToPattern(BaseSinkRecipientPayloadTypesTest.SINK_BINARY_VALUE)).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)ExternalResourcesMock.applySinkRecipientStructuredModeCommonMappings(WireMock.post((String)"/external-resource/sink-recipient-structured-mode-json-payload-data")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"data.PROPERTY_1", (StringValuePattern)WireMock.equalTo((String)"PROPERTY_1_VALUE"))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)ExternalResourcesMock.applySinkRecipientStructuredModeCommonMappings(WireMock.post((String)"/external-resource/sink-recipient-structured-mode-binary-payload-data")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"data_base64", (StringValuePattern)WireMock.equalTo((String)Base64.getEncoder().encodeToString(BaseSinkRecipientPayloadTypesTest.SINK_BINARY_VALUE)))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
    }

    private static MappingBuilder applySinkRecipientBinaryModeCommonMappings(MappingBuilder mappingBuilder) {
        return mappingBuilder.withHeader("Content-Type", WireMock.equalTo((String)"SINK_CE_DATACONTENTTYPE")).withHeader("ce-specversion", WireMock.equalTo((String)BaseSinkRecipientPayloadTypesTest.SINK_CE_SPECVERSION.toString())).withHeader("ce-type", WireMock.equalTo((String)"SINK_CE_TYPE")).withHeader("ce-dataschema", WireMock.equalTo((String)BaseSinkRecipientPayloadTypesTest.SINK_CE_DATASCHEMA.toString())).withHeader("ce-source", WireMock.equalTo((String)BaseSinkRecipientPayloadTypesTest.SINK_CE_SOURCE.toString())).withHeader("ce-subject", WireMock.equalTo((String)"SINK_CE_SUBJECT")).withHeader("ce-sinkextension1name", WireMock.equalTo((String)"SINK_EXTENSION_1_VALUE")).withHeader("ce-sinkextension2name", WireMock.equalTo((String)"SINK_EXTENSION_2_VALUE")).withHeader("ce-limit", WireMock.equalTo((String)LIMIT_QUERY_PARAM_VALUE));
    }

    private static MappingBuilder applySinkRecipientStructuredModeCommonMappings(MappingBuilder mappingBuilder) {
        return mappingBuilder.withHeader("Content-Type", WireMock.equalTo((String)"application/cloudevents+json")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"specversion", (StringValuePattern)WireMock.equalTo((String)BaseSinkRecipientPayloadTypesTest.SINK_CE_SPECVERSION.toString()))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"type", (StringValuePattern)WireMock.equalTo((String)"SINK_CE_TYPE"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"datacontenttype", (StringValuePattern)WireMock.equalTo((String)"SINK_CE_DATACONTENTTYPE"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"dataschema", (StringValuePattern)WireMock.equalTo((String)BaseSinkRecipientPayloadTypesTest.SINK_CE_DATASCHEMA.toString()))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"source", (StringValuePattern)WireMock.equalTo((String)BaseSinkRecipientPayloadTypesTest.SINK_CE_SOURCE.toString()))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"subject", (StringValuePattern)WireMock.equalTo((String)"SINK_CE_SUBJECT"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"sinkextension1name", (StringValuePattern)WireMock.equalTo((String)"SINK_EXTENSION_1_VALUE"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"sinkextension2name", (StringValuePattern)WireMock.equalTo((String)"SINK_EXTENSION_2_VALUE"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)LIMIT_QUERY_PARAM, (StringValuePattern)WireMock.equalTo((String)LIMIT_QUERY_PARAM_VALUE)));
    }

    private static String addQueryParams(String url) {
        return String.format("%s?%s=%s", url, "HTTP_QUERY_PARAM_1", "HTTP_QUERY_PARAM_1_VALUE");
    }

    public static interface ExternalResourcesMockAware {
        public void setExternalResourcesServer(WireMockServer var1);
    }
}

