/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.kie.kogito.jobs.service.health.HealthCheckUtils;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;
import org.kie.kogito.jobs.service.scheduler.impl.VertxTimerServiceScheduler;

public abstract class CommonBaseJobResourceTest {
    protected static final String CALLBACK_ENDPOINT = "http://localhost:%d/callback";
    protected static final String PROCESS_ID = "processId";
    protected static final String PROCESS_INSTANCE_ID = "processInstanceId";
    protected static final String ROOT_PROCESS_ID = "rootProcessId";
    protected static final String ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    protected static final String NODE_INSTANCE_ID = "nodeInstanceId";
    protected static final int PRIORITY = 1;
    protected static final int BAD_REQUEST = 400;
    protected static final int OK = 200;
    @ConfigProperty(name="quarkus.http.test-port")
    protected int port;
    @Inject
    protected ObjectMapper objectMapper;
    @Inject
    protected TimerDelegateJobScheduler scheduler;
    @Inject
    protected VertxTimerServiceScheduler timer;

    @BeforeEach
    void init() {
        HealthCheckUtils.awaitReadyHealthCheck(1, TimeUnit.MINUTES);
    }

    @AfterEach
    void tearDown() {
        this.scheduler.setForceExecuteExpiredJobs(false);
    }

    protected abstract String getCreatePath();

    protected abstract String getGetJobQuery(String var1);

    protected String getCallbackEndpoint() {
        return String.format(CALLBACK_ENDPOINT, this.port);
    }

    protected ValidatableResponse create(String body) {
        return (ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post(this.getCreatePath(), new Object[0])).then();
    }

    protected <T> T getJob(String jobId, Class<T> type) {
        return this.getJob(jobId, type, 200);
    }

    protected <T> T getJob(String jobId, Class<T> type, int code) {
        try {
            return (T)this.objectMapper.readValue(((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).get(this.getGetJobQuery(jobId), new Object[0])).then()).statusCode(code)).extract().body().asByteArray(), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ValidatableResponse deleteJob(String jobId) {
        return (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).delete(this.getGetJobQuery(jobId), new Object[0])).then()).statusCode(200);
    }

    protected void assertJobHasFinished(String jobId, long atMostTimeoutInSeconds) {
        Awaitility.await().atMost(atMostTimeoutInSeconds, TimeUnit.SECONDS).with().pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).get(this.getGetJobQuery(jobId), new Object[0])).then()).statusCode(404));
    }
}

