/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.resource.CommonBaseJobResourceTest;
import org.kie.kogito.jobs.service.utils.DateUtil;

public abstract class BaseJobResourceTest
extends CommonBaseJobResourceTest {
    @Override
    protected String getCreatePath() {
        return "/jobs";
    }

    @Override
    protected String getGetJobQuery(String jobId) {
        return String.format("/jobs/%s", jobId);
    }

    @Test
    void create() throws Exception {
        Job job = this.buildJob("1");
        ScheduledJob response = (ScheduledJob)((ValidatableResponse)this.create(this.jobToJson(job)).statusCode(200)).extract().as(ScheduledJob.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)job, (Object)response);
    }

    @Test
    void createWithMissingAttributes() throws Exception {
        Job job = JobBuilder.builder().id("1").callbackEndpoint(this.getCallbackEndpoint()).build();
        this.create(this.jobToJson(job)).statusCode(400);
    }

    private String jobToJson(Job job) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)job);
    }

    private Job buildJob(String id) {
        return this.buildJob(id, DateUtil.now().plusSeconds(10L));
    }

    private Job buildJob(String id, ZonedDateTime expirationTime, Integer repeatLimit, Long repeatInterval) {
        return JobBuilder.builder().id(id).expirationTime(expirationTime).repeatInterval(repeatInterval).repeatLimit(repeatLimit).callbackEndpoint(this.getCallbackEndpoint()).processId("processId").processInstanceId("processInstanceId").rootProcessId("rootProcessId").rootProcessInstanceId("rootProcessInstanceId").nodeInstanceId("nodeInstanceId").priority(Integer.valueOf(1)).build();
    }

    private Job buildJob(String id, ZonedDateTime expirationTime) {
        return this.buildJob(id, expirationTime, 0, 0L);
    }

    @Test
    void deleteAfterCreate() throws Exception {
        String id = "2";
        Job job = this.buildJob("2");
        this.create(this.jobToJson(job));
        ScheduledJob response = (ScheduledJob)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)"2").when().delete("/jobs/{id}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().as(ScheduledJob.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)job, (Object)response);
    }

    @Test
    void getAfterCreate() throws Exception {
        String id = "3";
        Job job = this.buildJob("3");
        this.create(this.jobToJson(job));
        this.assertGetScheduledJob("3");
    }

    @Test
    void executeTest() throws Exception {
        String id = "4";
        Job job = this.buildJob("4");
        this.create(this.jobToJson(job));
        ScheduledJob scheduledJob = this.assertGetScheduledJob("4");
        org.junit.jupiter.api.Assertions.assertEquals((Object)scheduledJob.getId(), (Object)job.getId());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (Integer)scheduledJob.getRetries());
        org.junit.jupiter.api.Assertions.assertEquals((Object)JobStatus.SCHEDULED, (Object)scheduledJob.getStatus());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)scheduledJob.getScheduledId());
    }

    @Test
    void cancelRunningNonPeriodicJobTest() throws Exception {
        String id = UUID.randomUUID().toString();
        Job job = this.buildJob(id, DateUtil.now().plus(10L, ChronoUnit.SECONDS));
        this.create(this.jobToJson(job));
        this.assertGetScheduledJob(id);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> {
            ScheduledJob scheduledJob = this.assertCancelScheduledJob(id);
            this.assertJobNotFound(id);
            this.assertJobNotScheduledOnVertx(scheduledJob);
        });
    }

    @Test
    void cancelRunningPeriodicJobTest() throws Exception {
        String id = UUID.randomUUID().toString();
        int timeMillis = 1000;
        Job job = this.buildJob(id, DateUtil.now().plus(timeMillis, ChronoUnit.MILLIS), 10, 500L);
        this.create(this.jobToJson(job));
        this.assertGetScheduledJob(id);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            ScheduledJob scheduledJob = this.assertGetScheduledJob(id);
            Assertions.assertThat((Integer)scheduledJob.getExecutionCounter()).isPositive();
            this.assertCancelScheduledJob(id);
            this.assertJobNotFound(id);
            this.assertJobNotScheduledOnVertx(scheduledJob);
        });
    }

    private void assertJobNotScheduledOnVertx(ScheduledJob scheduledJob) {
        this.assertJobScheduledOnVertx(scheduledJob, false);
    }

    private void assertJobScheduledOnVertx(ScheduledJob scheduledJob, boolean wasScheduled) {
        Long scheduledId = Long.valueOf(scheduledJob.getScheduledId());
        boolean timerCanceled = this.timer.getVertx().cancelTimer(scheduledId.longValue());
        Assertions.assertThat((boolean)timerCanceled).isEqualTo(wasScheduled);
    }

    private void assertJobNotFound(String id) {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)id).when().get("/jobs/{id}", new Object[0])).then()).statusCode(404);
    }

    private ScheduledJob assertCancelScheduledJob(String id) {
        ScheduledJob scheduledJob = (ScheduledJob)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)id).when().delete("/jobs/{id}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).assertThat()).extract().as(ScheduledJob.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)scheduledJob.getId(), (Object)id);
        org.junit.jupiter.api.Assertions.assertEquals((Object)JobStatus.CANCELED, (Object)scheduledJob.getStatus());
        Assertions.assertThat((String)scheduledJob.getScheduledId()).isNotBlank();
        return scheduledJob;
    }

    private ScheduledJob assertGetScheduledJob(String id) {
        return this.assertGetScheduledJob(id, true);
    }

    private ScheduledJob assertGetScheduledJob(String id, boolean wasScheduled) {
        ScheduledJob scheduledJob = (ScheduledJob)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)id).when().get("/jobs/{id}", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).assertThat()).extract().as(ScheduledJob.class);
        Assertions.assertThat((String)scheduledJob.getId()).isEqualTo(id);
        Assertions.assertThat((Integer)scheduledJob.getPriority()).isEqualTo(1);
        Assertions.assertThat((String)scheduledJob.getProcessId()).isEqualTo("processId");
        Assertions.assertThat((String)scheduledJob.getProcessInstanceId()).isEqualTo("processInstanceId");
        Assertions.assertThat((String)scheduledJob.getRootProcessId()).isEqualTo("rootProcessId");
        Assertions.assertThat((String)scheduledJob.getRootProcessInstanceId()).isEqualTo("rootProcessInstanceId");
        Assertions.assertThat((String)scheduledJob.getNodeInstanceId()).isEqualTo("nodeInstanceId");
        Assertions.assertThat((String)scheduledJob.getCallbackEndpoint()).isEqualTo(this.getCallbackEndpoint());
        Assertions.assertThat((Comparable)scheduledJob.getStatus()).isEqualTo((Object)JobStatus.SCHEDULED);
        if (wasScheduled) {
            Assertions.assertThat((String)scheduledJob.getScheduledId()).isNotBlank();
        } else {
            Assertions.assertThat((String)scheduledJob.getScheduledId()).isBlank();
        }
        return scheduledJob;
    }

    @Test
    void testCreateExpiredJob() throws Exception {
        this.createExpiredJob().statusCode(400);
    }

    @Test
    void testForcingCreateExpiredJob() throws Exception {
        this.scheduler.setForceExecuteExpiredJobs(true);
        this.createExpiredJob().statusCode(200);
    }

    private ValidatableResponse createExpiredJob() throws JsonProcessingException {
        Job job = JobBuilder.builder().id(UUID.randomUUID().toString()).expirationTime(DateUtil.now().minusMinutes(10L)).callbackEndpoint(this.getCallbackEndpoint()).processId("processId").processInstanceId("processInstanceId").rootProcessId("rootProcessId").rootProcessInstanceId("rootProcessInstanceId").nodeInstanceId("nodeInstanceId").priority(Integer.valueOf(1)).build();
        return this.create(this.jobToJson(job));
    }

    @Test
    void patchInvalidAttributesTest() throws Exception {
        String id = UUID.randomUUID().toString();
        Job job = this.buildJob(id);
        this.create(this.jobToJson(job));
        String newCallbackEndpoint = "http://localhost/newcallback";
        Job toPatch = JobBuilder.builder().callbackEndpoint("http://localhost/newcallback").build();
        this.assertPatch(id, toPatch, 400);
        toPatch = JobBuilder.builder().priority(Integer.valueOf(10)).build();
        this.assertPatch(id, toPatch, 400);
        toPatch = JobBuilder.builder().repeatLimit(Integer.valueOf(1)).repeatInterval(Long.valueOf(1L)).build();
        this.assertPatch(id, toPatch, 200);
    }

    private void assertPatch(String id, Job toPatch, int i) throws JsonProcessingException {
        ((ValidatableResponse)((Response)RestAssured.given().pathParam("id", (Object)id).contentType(ContentType.JSON).body(this.jobToJson(toPatch)).when().patch("/jobs/{id}", new Object[0])).then()).statusCode(i);
    }

    @Test
    void patchInvalidIdPathTest() throws Exception {
        String id = UUID.randomUUID().toString();
        Job job = this.buildJob(id);
        this.create(this.jobToJson(job));
        Job toPatch = JobBuilder.builder().expirationTime(DateUtil.now()).build();
        this.assertPatch("invalid", toPatch, 404);
        toPatch = JobBuilder.builder().id("differentId").build();
        this.assertPatch(id, toPatch, 400);
    }

    @Test
    void patchReschedulingTest() throws Exception {
        String id = UUID.randomUUID().toString();
        Job job = this.buildJob(id, DateUtil.now().plusHours(1L));
        this.create(this.jobToJson(job));
        this.assertGetScheduledJob(id, false);
        Job toPatch = JobBuilder.builder().expirationTime(DateUtil.now().plusSeconds(20L)).build();
        this.assertPatch(id, toPatch, 200);
        this.assertJobScheduledOnVertx(this.assertGetScheduledJob(id), true);
    }
}

