/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.marshaller;

import io.vertx.core.json.JsonObject;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.repository.marshaller.TriggerMarshaller;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;

class TriggerMarshallerTest {
    TriggerMarshaller marshaller = new TriggerMarshaller();

    TriggerMarshallerTest() {
    }

    @Test
    void marshallIntervalTrigger() {
        Date startTime = new Date();
        Date endTime = new Date();
        Date nextFireTime = new Date();
        Random random = new Random();
        int repeatLimit = random.nextInt();
        int repeatCount = random.nextInt();
        long period = random.nextLong();
        IntervalTrigger trigger = new IntervalTrigger();
        trigger.setStartTime(startTime);
        trigger.setEndTime(endTime);
        trigger.setRepeatLimit(repeatLimit);
        trigger.setRepeatCount(repeatCount);
        trigger.setNextFireTime(nextFireTime);
        trigger.setPeriod(period);
        JsonObject jsonObject = this.marshaller.marshall((Trigger)trigger);
        Assertions.assertThat((Iterable)jsonObject).isEqualTo((Object)new JsonObject().put("startTime", (Object)startTime.getTime()).put("endTime", (Object)endTime.getTime()).put("nextFireTime", (Object)nextFireTime.getTime()).put("repeatLimit", (Object)repeatLimit).put("repeatCount", (Object)repeatCount).put("period", (Object)period).put("classType", (Object)IntervalTrigger.class.getName()));
    }

    @Test
    void marshallPointInTimeTriggerAccessor() {
        Date time = new Date();
        PointInTimeTrigger trigger = new PointInTimeTrigger(time.getTime(), null, null);
        JsonObject jsonObject = this.marshaller.marshall((Trigger)trigger);
        Assertions.assertThat((Iterable)jsonObject).isEqualTo((Object)new JsonObject().put("nextFireTime", (Object)time.getTime()).put("classType", (Object)PointInTimeTrigger.class.getName()));
    }

    @Test
    void marshallSimpleTimerTrigger() {
        Date startTime = new Date();
        long period = 4L;
        ChronoUnit periodUnit = ChronoUnit.HOURS;
        int repeatCount = 3;
        Date endTime = new Date(startTime.getTime() + 10000L);
        String zoneId = "+02:00";
        SimpleTimerTrigger trigger = new SimpleTimerTrigger(startTime, period, periodUnit, repeatCount, endTime, zoneId);
        JsonObject jsonObject = this.marshaller.marshall((Trigger)trigger);
        Assertions.assertThat((Iterable)jsonObject).isEqualTo((Object)new JsonObject().put("startTime", (Object)startTime.getTime()).put("period", (Object)period).put("periodUnit", (Object)periodUnit.name()).put("repeatCount", (Object)repeatCount).put("endTime", (Object)endTime.getTime()).put("zoneId", (Object)zoneId).put("nextFireTime", (Object)startTime.getTime()).put("currentRepeatCount", (Object)0).put("endTimeReached", (Object)false).put("classType", (Object)SimpleTimerTrigger.class.getName()));
    }

    @Test
    void marshallNull() {
        JsonObject jsonObject = this.marshaller.marshall(null);
        Assertions.assertThat((Iterable)jsonObject).isNull();
    }

    @Test
    void unmarshallIntervalTrigger() {
        Date startTime = new Date();
        Date endTime = new Date();
        Date nextFireTime = new Date();
        Random random = new Random();
        int repeatLimit = random.nextInt();
        int repeatCount = random.nextInt();
        long period = random.nextLong();
        JsonObject jsonObject = new JsonObject().put("startTime", (Object)startTime.getTime()).put("endTime", (Object)endTime.getTime()).put("nextFireTime", (Object)nextFireTime.getTime()).put("repeatLimit", (Object)repeatLimit).put("repeatCount", (Object)repeatCount).put("period", (Object)period).put("classType", (Object)IntervalTrigger.class.getName());
        Trigger trigger = this.marshaller.unmarshall(jsonObject);
        IntervalTrigger expected = new IntervalTrigger();
        expected.setStartTime(startTime);
        expected.setEndTime(endTime);
        expected.setRepeatLimit(repeatLimit);
        expected.setRepeatCount(repeatCount);
        expected.setNextFireTime(nextFireTime);
        expected.setPeriod(period);
        Assertions.assertThat((Object)trigger).hasToString(expected.toString());
    }

    @Test
    void unmarshallPointInTimeTriggerAccessor() {
        Date time = new Date();
        JsonObject jsonObject = new JsonObject().put("nextFireTime", (Object)time.getTime()).put("classType", (Object)PointInTimeTrigger.class.getName());
        Trigger trigger = this.marshaller.unmarshall(jsonObject);
        Assertions.assertThat((Object)trigger).hasToString(new PointInTimeTrigger(time.getTime(), null, null).toString());
    }

    @Test
    void unmarshalSimpleTimerTrigger() {
        Date startTime = new Date();
        long period = 4L;
        ChronoUnit periodUnit = ChronoUnit.HOURS;
        int repeatCount = 3;
        Date endTime = new Date(startTime.getTime() + 10000L);
        String zoneId = "+02:00";
        JsonObject json = new JsonObject().put("startTime", (Object)startTime.getTime()).put("period", (Object)period).put("periodUnit", (Object)periodUnit.name()).put("repeatCount", (Object)repeatCount).put("endTime", (Object)endTime.getTime()).put("zoneId", (Object)zoneId).put("nextFireTime", (Object)startTime.getTime()).put("currentRepeatCount", (Object)0).put("endTimeReached", (Object)false).put("classType", (Object)SimpleTimerTrigger.class.getName());
        Trigger trigger = this.marshaller.unmarshall(json);
        Assertions.assertThat((Object)trigger).isExactlyInstanceOf(SimpleTimerTrigger.class);
        SimpleTimerTrigger simpleTimerTrigger = (SimpleTimerTrigger)trigger;
        Assertions.assertThat((Date)simpleTimerTrigger.getStartTime()).isEqualTo((Object)startTime);
        Assertions.assertThat((long)simpleTimerTrigger.getPeriod()).isEqualTo(period);
        Assertions.assertThat((Comparable)((Object)simpleTimerTrigger.getPeriodUnit())).isEqualTo((Object)periodUnit);
        Assertions.assertThat((int)simpleTimerTrigger.getRepeatCount()).isEqualTo(simpleTimerTrigger.getRepeatCount());
        Assertions.assertThat((Date)simpleTimerTrigger.getEndTime()).isEqualTo((Object)endTime);
        Assertions.assertThat((String)simpleTimerTrigger.getZoneId()).isEqualTo(zoneId);
        Assertions.assertThat((Date)simpleTimerTrigger.getNextFireTime()).isEqualTo((Object)startTime);
        Assertions.assertThat((Date)simpleTimerTrigger.hasNextFireTime()).isEqualTo((Object)startTime);
        Assertions.assertThat((int)simpleTimerTrigger.getCurrentRepeatCount()).isZero();
        Assertions.assertThat((boolean)simpleTimerTrigger.isEndTimeReached()).isFalse();
    }

    @Test
    void unmarshallNull() {
        Trigger trigger = this.marshaller.unmarshall(null);
        Assertions.assertThat((Object)trigger).isNull();
    }

    @Test
    void unmarshallInvalid() {
        Date time = new Date();
        JsonObject jsonObject = new JsonObject().put("nextFireTime", (Object)time.getTime());
        Trigger trigger = this.marshaller.unmarshall(jsonObject);
        Assertions.assertThat((Object)trigger).isNull();
    }
}

