/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.marshaller;

import io.vertx.core.json.JsonObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.model.RecipientInstance;
import org.kie.kogito.jobs.service.repository.marshaller.RecipientMarshaller;

class RecipientMarshallerTest {
    RecipientMarshaller marshaller = new RecipientMarshaller();

    RecipientMarshallerTest() {
    }

    @Test
    void marshall() {
        RecipientInstance recipient = new RecipientInstance((Recipient)HttpRecipient.builder().forStringPayload().url("test").build());
        JsonObject jsonObject = this.marshaller.marshall((org.kie.kogito.jobs.service.model.Recipient)recipient);
        Assertions.assertEquals((Object)RecipientMarshallerTest.buildRecipient(), (Object)jsonObject);
    }

    private static JsonObject buildRecipient() {
        return JsonObject.mapFrom((Object)HttpRecipient.builder().forStringPayload().url("test").build()).put("classType", (Object)HttpRecipient.class.getName());
    }

    @Test
    void marshallNull() {
        JsonObject jsonObject = this.marshaller.marshall(null);
        Assertions.assertNull((Object)jsonObject);
    }

    @Test
    void unmarshall() {
        JsonObject jsonObject = RecipientMarshallerTest.buildRecipient();
        org.kie.kogito.jobs.service.model.Recipient recipient = this.marshaller.unmarshall(jsonObject);
        Assertions.assertEquals((Object)HttpRecipient.builder().forStringPayload().url("test").build(), (Object)recipient.getRecipient());
    }

    @Test
    void unmarshallInvalid() {
        JsonObject jsonObject = new JsonObject();
        org.kie.kogito.jobs.service.model.Recipient recipient = this.marshaller.unmarshall(jsonObject);
        Assertions.assertNull((Object)recipient);
    }

    @Test
    void unmarshallNull() {
        org.kie.kogito.jobs.service.model.Recipient recipient = this.marshaller.unmarshall(null);
        Assertions.assertNull((Object)recipient);
    }
}

