/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.marshaller;

import io.vertx.core.json.JsonObject;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientStringPayloadData;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.model.RecipientInstance;
import org.kie.kogito.jobs.service.repository.marshaller.JobDetailsMarshaller;
import org.kie.kogito.jobs.service.repository.marshaller.RecipientMarshaller;
import org.kie.kogito.jobs.service.repository.marshaller.TriggerMarshaller;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

class JobDetailsMarshallerTest {
    JobDetailsMarshaller jobDetailsMarshaller;
    JobDetails jobDetails;
    JsonObject jsonObject;

    JobDetailsMarshallerTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobDetailsMarshaller = new JobDetailsMarshaller(new TriggerMarshaller(), new RecipientMarshaller());
        String id = "testId";
        String correlationId = "testCorrelationId";
        JobStatus status = JobStatus.SCHEDULED;
        Date date = new Date();
        ZonedDateTime lastUpdate = ZonedDateTime.ofInstant(date.toInstant(), DateUtil.DEFAULT_ZONE);
        Integer retries = 2;
        Integer priority = 3;
        Integer executionCounter = 4;
        String scheduledId = "testScheduledId";
        String payload = "test";
        RecipientInstance recipient = new RecipientInstance((org.kie.kogito.jobs.service.api.Recipient)HttpRecipient.builder().forStringPayload().url("url").payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)payload)).build());
        PointInTimeTrigger trigger = new PointInTimeTrigger(new Date().toInstant().toEpochMilli(), null, null);
        Long executionTimeout = 10L;
        ChronoUnit executionTimeoutUnit = ChronoUnit.SECONDS;
        this.jobDetails = JobDetails.builder().id(id).correlationId(correlationId).status(status).lastUpdate(lastUpdate).retries(retries).executionCounter(executionCounter).scheduledId(scheduledId).priority(priority).recipient((Recipient)recipient).trigger((Trigger)trigger).executionTimeout(executionTimeout).executionTimeoutUnit(executionTimeoutUnit).build();
        this.jsonObject = new JsonObject().put("id", (Object)id).put("correlationId", (Object)correlationId).put("status", (Object)status.name()).put("lastUpdate", (Object)date.getTime()).put("retries", (Object)retries).put("executionCounter", (Object)executionCounter).put("scheduledId", (Object)scheduledId).put("priority", (Object)priority).put("recipient", (Object)JsonObject.mapFrom((Object)HttpRecipient.builder().forStringPayload().url("url").payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)payload)).build()).put("classType", (Object)HttpRecipient.class.getName())).put("trigger", (Object)new JsonObject().put("nextFireTime", (Object)trigger.hasNextFireTime().getTime()).put("classType", (Object)PointInTimeTrigger.class.getName())).put("executionTimeout", (Object)executionTimeout).put("executionTimeoutUnit", (Object)executionTimeoutUnit.name());
    }

    @Test
    void marshall() {
        Assertions.assertEquals((Object)this.jsonObject, (Object)this.jobDetailsMarshaller.marshall(this.jobDetails));
    }

    @Test
    void marshallNull() {
        Assertions.assertNull((Object)this.jobDetailsMarshaller.marshall(null));
    }

    @Test
    void unmarshall() {
        Assertions.assertEquals((Object)this.jobDetails, (Object)this.jobDetailsMarshaller.unmarshall(this.jsonObject));
    }

    @Test
    void unmarshallNull() {
        Assertions.assertNull((Object)this.jobDetailsMarshaller.unmarshall(null));
    }
}

