/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.openapi;

import io.cloudevents.SpecVersion;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.openapi.JobServiceModelFilter;

class JobServiceModelFilterTest {
    JobServiceModelFilterTest() {
    }

    @Test
    void filterOpenAPI() {
        OpenAPI openAPI = OASFactory.createOpenAPI();
        Components components = OASFactory.createComponents().addSchema("JsonNode", OASFactory.createSchema().type(Schema.SchemaType.ARRAY)).addSchema("SpecVersion", OASFactory.createSchema().enumeration(Arrays.asList("V03", "V1"))).addSchema("Recipient", OASFactory.createSchema()).addSchema("Schedule", OASFactory.createSchema());
        openAPI.components(components);
        JobServiceModelFilter filter = new JobServiceModelFilter();
        filter.filterOpenAPI(openAPI);
        Schema jsonNodeSchema = (Schema)openAPI.getComponents().getSchemas().get("JsonNode");
        Assertions.assertThat((Object)jsonNodeSchema).isNotNull();
        Assertions.assertThat((Comparable)jsonNodeSchema.getType()).isEqualTo((Object)Schema.SchemaType.OBJECT);
        Schema specVersionSchema = (Schema)openAPI.getComponents().getSchemas().get("SpecVersion");
        Assertions.assertThat((Object)specVersionSchema).isNotNull();
        Assertions.assertThat((List)specVersionSchema.getEnumeration()).containsExactly(new Object[]{SpecVersion.V03.toString(), SpecVersion.V1.toString()});
        Schema recipientSchema = (Schema)openAPI.getComponents().getSchemas().get("Recipient");
        JobServiceModelFilterTest.assertSchemaDiscriminator(recipientSchema, Pair.of((Object)"http", (Object)"#/components/schemas/HttpRecipient"), Pair.of((Object)"sink", (Object)"#/components/schemas/SinkRecipient"));
        Schema scheduleSchema = (Schema)openAPI.getComponents().getSchemas().get("Schedule");
        JobServiceModelFilterTest.assertSchemaDiscriminator(scheduleSchema, Pair.of((Object)"cron", (Object)"#/components/schemas/CronSchedule"), Pair.of((Object)"timer", (Object)"#/components/schemas/TimerSchedule"));
    }

    @SafeVarargs
    private static void assertSchemaDiscriminator(Schema schema, Pair<String, String> ... mappingEntries) {
        Map<String, String> expectedEntries = Arrays.stream(mappingEntries).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Assertions.assertThat((Object)schema).isNotNull();
        Assertions.assertThat((List)schema.getRequired()).containsExactly((Object[])new String[]{"type"});
        Discriminator discriminator = schema.getDiscriminator();
        Assertions.assertThat((Object)discriminator).isNotNull();
        Assertions.assertThat((String)discriminator.getPropertyName()).isEqualTo("type");
        Assertions.assertThat((Map)discriminator.getMapping()).containsExactlyInAnyOrderEntriesOf(expectedEntries);
    }
}

