/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonFormat;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.event.CancelJobRequestEvent;
import org.kie.kogito.jobs.service.exception.JobServiceException;
import org.kie.kogito.jobs.service.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Publisher;

@ExtendWith(value={MockitoExtension.class})
public abstract class ReactiveMessagingEventConsumerTest<T extends ReactiveMessagingEventConsumer> {
    public static final String JOB_ID = "JOB_ID";
    public static final String INTERNAL_ERROR = "Internal error";
    public static final String JOB_QUERY_ERROR = "Job query error";
    public static final String EVENT_ID = "EVENT_ID";
    public static final URI EVENT_SOURCE = URI.create("http://event_source");
    @Mock
    private TimerDelegateJobScheduler scheduler;
    @Mock
    private ReactiveJobRepository jobRepository;
    public ObjectMapper objectMapper;
    @Mock
    private Message<CloudEvent> message;
    private T eventConsumer;
    @Captor
    private ArgumentCaptor<Throwable> errorCaptor;

    @BeforeEach
    void setUp() {
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)JsonFormat.getCloudEventJacksonModule());
        CompletableFuture<Object> ackCompletionState = CompletableFuture.completedFuture(null);
        ((Message)Mockito.lenient().doReturn(ackCompletionState).when(this.message)).ack();
        CompletableFuture<Object> nackCompletionStage = CompletableFuture.completedFuture(null);
        ((Message)Mockito.lenient().doReturn(nackCompletionStage).when(this.message)).nack((Throwable)ArgumentMatchers.any());
        this.eventConsumer = this.createEventConsumer(this.scheduler, this.jobRepository, this.objectMapper);
    }

    protected abstract T createEventConsumer(TimerDelegateJobScheduler var1, ReactiveJobRepository var2, ObjectMapper var3);

    @Test
    void onCreateProcessInstanceJobWithNonExistingJobSuccessful() throws Exception {
        this.prepareCreateProcessInstanceJobWithExistingJobResult(null);
        this.executeSuccessfulScheduledJobExecution();
    }

    @Test
    void onCreateProcessInstanceJobWithExistingScheduledJobSuccessful() throws Exception {
        JobDetails existingJob = JobDetails.builder().id(JOB_ID).status(JobStatus.SCHEDULED).build();
        this.prepareCreateProcessInstanceJobWithExistingJobResult(existingJob);
        this.executeSuccessfulScheduledJobExecution();
    }

    @Test
    void onCreateProcessInstanceJobWithExistingRetryJobSuccessful() throws Exception {
        this.onCreateProcessInstanceJobExistingNonScheduledSuccessful(JobStatus.RETRY);
    }

    @Test
    void onCreateProcessInstanceJobWithExistingCanceledJobSuccessful() throws Exception {
        this.onCreateProcessInstanceJobExistingNonScheduledSuccessful(JobStatus.CANCELED);
    }

    @Test
    void onCreateProcessInstanceJobWithExistingErrorJobSuccessful() throws Exception {
        this.onCreateProcessInstanceJobExistingNonScheduledSuccessful(JobStatus.ERROR);
    }

    @Test
    void onCreateProcessInstanceJobWithExistingExecutedJobSuccessful() throws Exception {
        this.onCreateProcessInstanceJobExistingNonScheduledSuccessful(JobStatus.EXECUTED);
    }

    @Test
    void onCreateProcessInstanceJobWithJobQueryError() throws Exception {
        CloudEvent event = this.newCreateProcessInstanceJobRequestCloudEvent();
        ((Message)Mockito.doReturn((Object)event).when(this.message)).getPayload();
        CompletableFuture queryJobStage = CompletableFuture.failedFuture(new Exception(JOB_QUERY_ERROR));
        ((ReactiveJobRepository)Mockito.doReturn(queryJobStage).when((Object)this.jobRepository)).get(JOB_ID);
        this.executeFailedExecution(JOB_QUERY_ERROR);
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.never())).schedule((JobDetails)ArgumentMatchers.any());
    }

    @Test
    void onCreateProcessInstanceJobWithJobScheduleError() throws Exception {
        CloudEvent event = this.newCreateProcessInstanceJobRequestCloudEvent();
        ((Message)Mockito.doReturn((Object)event).when(this.message)).getPayload();
        JobDetails existingJob = JobDetails.builder().id(JOB_ID).status(JobStatus.SCHEDULED).build();
        CompletionStage<JobDetails> queryJobStage = CompletableFuture.completedStage(existingJob);
        ((ReactiveJobRepository)Mockito.doReturn(queryJobStage).when((Object)this.jobRepository)).get(JOB_ID);
        CompletionStage createJobFailingStage = CompletableFuture.failedStage(new Exception(INTERNAL_ERROR));
        Publisher schedulePublisher = ReactiveStreams.fromCompletionStage(createJobFailingStage).buildRs();
        ((TimerDelegateJobScheduler)Mockito.doReturn((Object)schedulePublisher).when((Object)this.scheduler)).schedule((JobDetails)ArgumentMatchers.any());
        this.executeFailedExecution(INTERNAL_ERROR);
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler)).schedule((JobDetails)ArgumentMatchers.any());
    }

    private void onCreateProcessInstanceJobExistingNonScheduledSuccessful(JobStatus nonScheduledStatus) throws Exception {
        JobDetails existingJob = JobDetails.builder().id(JOB_ID).status(nonScheduledStatus).build();
        this.prepareCreateProcessInstanceJobWithExistingJobResult(existingJob);
        this.executeSuccessfulNonScheduledJobExecution();
    }

    private void prepareCreateProcessInstanceJobWithExistingJobResult(JobDetails existingJobResult) throws Exception {
        CloudEvent event = this.newCreateProcessInstanceJobRequestCloudEvent();
        ((Message)Mockito.doReturn((Object)event).when(this.message)).getPayload();
        CompletableFuture<JobDetails> queryJobStage = CompletableFuture.completedFuture(existingJobResult);
        ((ReactiveJobRepository)Mockito.doReturn(queryJobStage).when((Object)this.jobRepository)).get(JOB_ID);
        JobDetails createdJob = JobDetails.builder().build();
        Publisher schedulePublisher = ReactiveStreams.of((Object)createdJob).buildRs();
        ((TimerDelegateJobScheduler)Mockito.lenient().doReturn((Object)schedulePublisher).when((Object)this.scheduler)).schedule((JobDetails)ArgumentMatchers.any());
    }

    private void executeSuccessfulScheduledJobExecution() {
        this.executeSuccessfulExecution();
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler)).schedule((JobDetails)ArgumentMatchers.any());
    }

    private void executeSuccessfulNonScheduledJobExecution() {
        this.executeSuccessfulExecution();
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.never())).schedule((JobDetails)ArgumentMatchers.any());
    }

    @Test
    void onCancelJobWithNonExistingJobSuccessful() throws Exception {
        this.prepareCancelJobWithExistingJob(null);
        this.executeSuccessfulCancelJob();
    }

    @Test
    void onCancelJobWithExistingJobSuccessful() throws Exception {
        JobDetails jobDetails = JobDetails.builder().id(JOB_ID).build();
        this.prepareCancelJobWithExistingJob(jobDetails);
        this.executeSuccessfulCancelJob();
    }

    private void prepareCancelJobWithExistingJob(JobDetails existingJob) throws Exception {
        CloudEvent event = this.newCancelJobRequestCloudEvent();
        ((Message)Mockito.doReturn((Object)event).when(this.message)).getPayload();
        CompletableFuture<JobDetails> completionStage = CompletableFuture.completedFuture(existingJob);
        ((TimerDelegateJobScheduler)Mockito.doReturn(completionStage).when((Object)this.scheduler)).cancel(JOB_ID);
    }

    private void executeSuccessfulCancelJob() {
        this.executeSuccessfulExecution();
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler)).cancel(JOB_ID);
    }

    @Test
    void onCancelJobWithError() throws Exception {
        CloudEvent event = this.newCancelJobRequestCloudEvent();
        ((Message)Mockito.doReturn((Object)event).when(this.message)).getPayload();
        CompletableFuture completionStage = CompletableFuture.failedFuture(new Exception(INTERNAL_ERROR));
        ((TimerDelegateJobScheduler)Mockito.doReturn(completionStage).when((Object)this.scheduler)).cancel(JOB_ID);
        this.executeFailedExecution(INTERNAL_ERROR);
        ((TimerDelegateJobScheduler)Mockito.verify((Object)this.scheduler)).cancel(JOB_ID);
    }

    private void executeSuccessfulExecution() {
        this.eventConsumer.onKogitoServiceRequest(this.message).subscribe().with(callback -> {}, org.junit.jupiter.api.Assertions::assertNotNull);
        ((Message)Mockito.verify(this.message)).ack();
        ((Message)Mockito.verify(this.message, (VerificationMode)Mockito.never())).nack((Throwable)ArgumentMatchers.any());
    }

    private void executeFailedExecution(String withErrorMessage) {
        this.eventConsumer.onKogitoServiceRequest(this.message).subscribe().with(callback -> {}, org.junit.jupiter.api.Assertions::assertNull);
        ((Message)Mockito.verify(this.message, (VerificationMode)Mockito.never())).ack();
        ((Message)Mockito.verify(this.message)).nack((Throwable)this.errorCaptor.capture());
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Throwable)this.errorCaptor.getValue())).isNotNull()).isInstanceOf(JobServiceException.class)).hasMessageContaining(withErrorMessage);
    }

    public CloudEvent newCreateProcessInstanceJobRequestCloudEvent() throws Exception {
        Job job = new Job();
        job.setId(JOB_ID);
        return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(EVENT_ID).withSource(EVENT_SOURCE).withType("CreateProcessInstanceJobRequest").withData(this.objectMapper.writeValueAsBytes((Object)job))).build();
    }

    public CloudEvent newCancelJobRequestCloudEvent() throws Exception {
        CancelJobRequestEvent.JobId jobId = new CancelJobRequestEvent.JobId(JOB_ID);
        return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(EVENT_ID).withSource(EVENT_SOURCE).withType("CancelJobRequest").withData(this.objectMapper.writeValueAsBytes((Object)jobId))).build();
    }
}

