/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.URIBuilder;
import org.kie.kogito.jobs.api.event.CancelJobRequestEvent;
import org.kie.kogito.jobs.api.event.CreateProcessInstanceJobRequestEvent;
import org.kie.kogito.jobs.api.event.JobCloudEvent;
import org.kie.kogito.jobs.api.event.serialization.JobCloudEventSerializer;
import org.kie.kogito.jobs.service.health.HealthCheckUtils;

public abstract class BaseMessagingApiTest {
    private static final String KOGITO_JOB_SERVICE_JOB_REQUEST_EVENTS_EMITTER = "kogito-job-service-job-request-events-emitter";
    private static final String TEST_SOURCE = "http://testSource";
    private static final String JOB_ID_1 = "JOB_ID_1";
    private static final String JOB_ID_2 = "JOB_ID_2";
    private static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    private static final String PROCESS_ID = "PROCESS_ID";
    private static final String ROOT_PROCESS_INSTANCE_ID = "ROOT_PROCESS_INSTANCE_ID";
    private static final String ROOT_PROCESS_ID = "ROOT_PROCESS_ID";
    private static final String KOGITO_ADDONS = "KOGITO_ADDONS";
    private static final String NODE_INSTANCE_ID_1 = "NODE_INSTANCE_ID_1";
    private static final String NODE_INSTANCE_ID_2 = "NODE_INSTANCE_ID_2";
    private static final long REPEAT_INTERVAL = 1000L;
    private static final int REPEAT_LIMIT = 3;
    private static final int PRIORITY = 0;
    private static final AtomicInteger CHECK_CALLBACK_NODE_INSTANCE_ID = new AtomicInteger();
    private static final int CALLBACK_EXECUTIONS_QUERY_TIMOUT_IN_SECONDS = 120;
    private static final int CALLBACK_EXECUTIONS_QUERY_POLL_INTERVAL_IN_MILLISECONDS = 3000;
    private static final String CALLBACK_RESOURCE_PATH = "/test/callback/management/jobs";
    @Inject
    @ConfigProperty(name="quarkus.http.test-port")
    public int port;
    @Inject
    @Channel(value="kogito-job-service-job-request-events-emitter")
    public Emitter<String> jobEventsEmitter;
    private final JobCloudEventSerializer serializer = new JobCloudEventSerializer();

    @BeforeEach
    void init() throws Exception {
        HealthCheckUtils.awaitReadyHealthCheck(2, TimeUnit.MINUTES);
    }

    @Test
    @Timeout(value=10L, unit=TimeUnit.MINUTES)
    protected void createJob() {
        this.assertCallbackResource();
        ZonedDateTime expiration = ZonedDateTime.now().plusSeconds(10L);
        String callback = BaseMessagingApiTest.buildCallbackEndpoint(this.getCallbackResourceURL(), PROCESS_ID, PROCESS_INSTANCE_ID, NODE_INSTANCE_ID_1);
        CreateProcessInstanceJobRequestEvent event = (CreateProcessInstanceJobRequestEvent)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)CreateProcessInstanceJobRequestEvent.builder().source(URI.create(TEST_SOURCE))).job(new Job(JOB_ID_1, expiration, Integer.valueOf(0), callback, PROCESS_INSTANCE_ID, ROOT_PROCESS_INSTANCE_ID, PROCESS_ID, ROOT_PROCESS_ID, Long.valueOf(1000L), Integer.valueOf(3), NODE_INSTANCE_ID_1)).processInstanceId(PROCESS_INSTANCE_ID)).processId(PROCESS_ID)).rootProcessInstanceId(ROOT_PROCESS_INSTANCE_ID)).rootProcessId(ROOT_PROCESS_ID)).kogitoAddons(KOGITO_ADDONS)).build();
        String jsonEvent = this.serializer.serialize((JobCloudEvent)event);
        this.jobEventsEmitter.send((Object)jsonEvent);
        BaseMessagingApiTest.waitUntilResult(() -> this.getJobCallbackExecutions(NODE_INSTANCE_ID_1), executions -> Objects.equals(executions, "2"), 120, 3000);
    }

    @Test
    @Timeout(value=10L, unit=TimeUnit.MINUTES)
    protected void cancelJob() {
        this.assertCallbackResource();
        ZonedDateTime expiration = ZonedDateTime.now().plusDays(1L);
        String callback = BaseMessagingApiTest.buildCallbackEndpoint(this.getCallbackResourceURL(), PROCESS_ID, PROCESS_INSTANCE_ID, NODE_INSTANCE_ID_2);
        CreateProcessInstanceJobRequestEvent createJobEvent = (CreateProcessInstanceJobRequestEvent)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)CreateProcessInstanceJobRequestEvent.builder().source(URI.create(TEST_SOURCE))).job(new Job(JOB_ID_2, expiration, Integer.valueOf(0), callback, PROCESS_INSTANCE_ID, ROOT_PROCESS_INSTANCE_ID, PROCESS_ID, ROOT_PROCESS_ID, Long.valueOf(1000L), Integer.valueOf(3), NODE_INSTANCE_ID_2)).processInstanceId(PROCESS_INSTANCE_ID)).processId(PROCESS_ID)).rootProcessInstanceId(ROOT_PROCESS_INSTANCE_ID)).rootProcessId(ROOT_PROCESS_ID)).kogitoAddons(KOGITO_ADDONS)).build();
        String createJobEventJson = this.serializer.serialize((JobCloudEvent)createJobEvent);
        this.jobEventsEmitter.send((Object)createJobEventJson);
        String jobUrl = "/jobs/JOB_ID_2";
        BaseMessagingApiTest.waitUntilResult(() -> BaseMessagingApiTest.getJob(jobUrl), response -> BaseMessagingApiTest.expectedJobExists(JOB_ID_2, response), 120, 3000);
        CancelJobRequestEvent cancelJobEvent = (CancelJobRequestEvent)((CancelJobRequestEvent.Builder)CancelJobRequestEvent.builder().source(URI.create(TEST_SOURCE))).jobId(JOB_ID_2).build();
        String cancelJobEventJson = this.serializer.serialize((JobCloudEvent)cancelJobEvent);
        this.jobEventsEmitter.send((Object)cancelJobEventJson);
        BaseMessagingApiTest.waitUntilResult(() -> BaseMessagingApiTest.getJob(jobUrl), response -> BaseMessagingApiTest.expectedJobDontExists(JOB_ID_2, response), 120, 3000);
    }

    private String getCallbackResourceURL() {
        return "http://localhost:" + this.port;
    }

    private void assertCallbackResource() {
        String checkCallbackNode = "chekCallbackNode_" + CHECK_CALLBACK_NODE_INSTANCE_ID.getAndIncrement();
        String callbackDirectCheckURL = BaseMessagingApiTest.buildCallbackEndpoint(this.getCallbackResourceURL(), PROCESS_ID, PROCESS_INSTANCE_ID, checkCallbackNode);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body("{}").when().post(callbackDirectCheckURL, new Object[0])).then()).statusCode(200)).extract().statusCode();
        Assertions.assertThat((String)this.getJobCallbackExecutions(checkCallbackNode)).isEqualTo("1");
    }

    private String getJobCallbackExecutions(String timerId) {
        String path = String.format("/test/callback/management/jobs/executions/%s", timerId);
        return ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).when().get(path, new Object[0])).then()).statusCode(200)).extract().body().asString();
    }

    private static Response getJob(String jobUrl) {
        return (Response)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).response().contentType(ContentType.JSON).when().get(jobUrl, new Object[0])).then()).extract().response();
    }

    private static String buildCallbackEndpoint(String serviceURL, String processId, String processInstanceId, String nodeId) {
        return URIBuilder.toURI((String)(serviceURL + "/test/callback/management/jobs/" + processId + "/instances/" + processInstanceId + "/timers/" + nodeId)).toString();
    }

    private static <T> void waitUntilResult(Supplier<T> resultProducer, Predicate<T> condition, int pollIntervalInMillis, int timoutInSeconds) {
        Awaitility.await().pollInterval((long)pollIntervalInMillis, TimeUnit.MILLISECONDS).atMost((long)timoutInSeconds, TimeUnit.SECONDS).until(() -> {
            Object result = resultProducer.get();
            return condition.test(result);
        });
    }

    private static boolean expectedJobExists(String jobId, Response response) {
        if (response.statusCode() == 404) {
            return false;
        }
        if ("".equals(response.asString())) {
            return false;
        }
        return jobId.equals(response.jsonPath().getString("id"));
    }

    private static boolean expectedJobDontExists(String jobId, Response response) {
        String expectedMessage = "Job not found id " + jobId;
        return response.statusCode() == 404 && expectedMessage.equals(response.jsonPath().getString("message"));
    }
}

