/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLInputObjectType;
import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.index.graphql.query.GraphQLQueryMapper;
import org.kie.kogito.index.graphql.query.GraphQLQueryParser;

public class GraphQLQueryParserRegistry {
    private static final GraphQLQueryParserRegistry REGISTRY = new GraphQLQueryParserRegistry();
    private final Map<String, GraphQLQueryParser> queryParser = new HashMap<String, GraphQLQueryParser>();

    private GraphQLQueryParserRegistry() {
    }

    public static GraphQLQueryParserRegistry get() {
        return REGISTRY;
    }

    public void registerParser(GraphQLInputObjectType type) {
        this.queryParser.put(type.getName(), new GraphQLQueryMapper().apply(type));
    }

    public void registerParsers(GraphQLInputObjectType ... types) {
        for (GraphQLInputObjectType type : types) {
            this.registerParser(type);
        }
    }

    public GraphQLQueryParser getParser(String name) {
        return this.queryParser.get(name);
    }
}

