/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertyDataFetcher
implements DataFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPropertyDataFetcher.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static TypeReference stringListTypeRef = new TypeReference<List<String>>(){};
    private static TypeReference numberListTypeRef = new TypeReference<List<Number>>(){};
    private static TypeReference booleanListTypeRef = new TypeReference<List<Boolean>>(){};

    public Object get(DataFetchingEnvironment environment) {
        String property = environment.getField().getName();
        Object source = environment.getSource();
        if (source instanceof JsonNode) {
            JsonNode jsonObject = (JsonNode)source;
            try {
                JsonNode value = jsonObject.findValue(property);
                if (value == null) {
                    return null;
                }
                switch (value.getNodeType()) {
                    case OBJECT: 
                    case POJO: {
                        return value;
                    }
                    case ARRAY: {
                        if (!value.isNull() && !value.isEmpty()) {
                            switch (value.get(0).getNodeType()) {
                                case STRING: {
                                    return mapper.readerFor(stringListTypeRef).readValue(value);
                                }
                                case NUMBER: {
                                    return mapper.readerFor(numberListTypeRef).readValue(value);
                                }
                                case BOOLEAN: {
                                    return mapper.readerFor(booleanListTypeRef).readValue(value);
                                }
                            }
                        }
                        return value;
                    }
                    case NUMBER: {
                        return value.numberValue();
                    }
                    case BOOLEAN: {
                        return value.asBoolean();
                    }
                    case STRING: {
                        return value.asText();
                    }
                }
                return null;
            }
            catch (Exception ex) {
                LOGGER.warn(ex.getMessage());
                return null;
            }
        }
        return null;
    }
}

