/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kie.kogito.event.process.AttachmentEventBody;
import org.kie.kogito.event.process.CommentEventBody;
import org.kie.kogito.event.process.MilestoneEventBody;
import org.kie.kogito.event.process.NodeInstanceEventBody;
import org.kie.kogito.event.process.ProcessErrorEventBody;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceEventBody;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.MilestoneStatus;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;

public final class TestUtils {
    private static final String MILESTONE_ID = UUID.randomUUID().toString();

    private TestUtils() {
    }

    public static int getPortFromConfig() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.http.test-port", Integer.class).orElse(8081);
    }

    public static String getDealsProtoBufferFile() throws Exception {
        return TestUtils.readFileContent("deals.proto");
    }

    public static String getTravelsProtoBufferFile() throws Exception {
        return TestUtils.readFileContent("travels.proto");
    }

    /*
     * Exception decompiling
     */
    public static String readFileContent(String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ProcessInstanceDataEvent getProcessCloudEvent(String processId, String processInstanceId, ProcessInstanceState status, String rootProcessInstanceId, String rootProcessId, String parentProcessInstanceId) {
        ProcessInstanceEventBody body = ProcessInstanceEventBody.create().id(processInstanceId).parentInstanceId(parentProcessInstanceId).rootInstanceId(rootProcessInstanceId).processId(processId).rootProcessId(rootProcessId).processName(RandomStringUtils.randomAlphabetic((int)10)).startDate(new Date()).endDate(status == ProcessInstanceState.COMPLETED ? Date.from(Instant.now().plus(1L, ChronoUnit.HOURS)) : null).state(Integer.valueOf(status.ordinal())).businessKey(RandomStringUtils.randomAlphabetic((int)10)).variables(TestUtils.getProcessInstanceVariablesMap()).milestones(Set.of(MilestoneEventBody.create().id(MILESTONE_ID).name("SimpleMilestone").status(MilestoneStatus.AVAILABLE.name()).build())).roles(new String[]{"admin"}).nodeInstance(NodeInstanceEventBody.create().id(processInstanceId + "-1").triggerTime(new Date()).nodeName("Start").nodeType("StartNode").nodeId("1").nodeDefinitionId("StartEvent_1").leaveTime(status == ProcessInstanceState.COMPLETED ? Date.from(Instant.now().plus(1L, ChronoUnit.HOURS)) : null).build()).error(status == ProcessInstanceState.ERROR ? ProcessErrorEventBody.create().nodeDefinitionId("StartEvent_1").errorMessage("Something went wrong").build() : null).build();
        return new ProcessInstanceDataEvent(URI.create("http://localhost:8080/" + processId).toString(), "jobs-management,prometheus-monitoring,process-management", body.metaData(), body);
    }

    public static ProcessInstance getProcessInstance(String processId, String processInstanceId, Integer status, String rootProcessInstanceId, String rootProcessId) {
        ProcessInstance pi = new ProcessInstance();
        pi.setId(processInstanceId);
        pi.setProcessId(processId);
        pi.setProcessName(RandomStringUtils.randomAlphabetic((int)10));
        pi.setRootProcessInstanceId(rootProcessInstanceId);
        pi.setParentProcessInstanceId(rootProcessInstanceId);
        pi.setRootProcessId(rootProcessId);
        pi.setRoles(Collections.singleton("admin"));
        pi.setVariables(TestUtils.getProcessInstanceVariablesJson());
        pi.setNodes(TestUtils.getNodeInstances(status));
        pi.setState(status);
        pi.setStart(ZonedDateTime.now());
        pi.setEnd(status.intValue() == ProcessInstanceState.COMPLETED.ordinal() ? ZonedDateTime.now().plus(1L, ChronoUnit.HOURS) : null);
        if (ProcessInstanceState.ERROR.ordinal() == status.intValue()) {
            pi.setError(new ProcessInstanceError("StartEvent_1", "Something went wrong"));
        }
        pi.setMilestones(TestUtils.getMilestones());
        pi.setBusinessKey(RandomStringUtils.randomAlphabetic((int)10));
        return pi;
    }

    private static List<NodeInstance> getNodeInstances(Integer status) {
        NodeInstance ni = new NodeInstance();
        ni.setId(UUID.randomUUID().toString());
        ni.setEnter(ZonedDateTime.now());
        ni.setName("Start");
        ni.setType("StartNode");
        ni.setNodeId("1");
        ni.setDefinitionId("StartEvent_1");
        ni.setExit(status.intValue() == ProcessInstanceState.COMPLETED.ordinal() ? ZonedDateTime.now().plus(1L, ChronoUnit.HOURS) : null);
        return Lists.newArrayList((Object[])new NodeInstance[]{ni});
    }

    private static List<Milestone> getMilestones() {
        return Lists.newArrayList((Object[])new Milestone[]{Milestone.builder().id(MILESTONE_ID).name("SimpleMilestone").status(MilestoneStatus.AVAILABLE.name()).build()});
    }

    public static Map<String, Object> getProcessInstanceVariablesMap() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> traveller = new HashMap<String, String>();
        traveller.put("firstName", "Maciej");
        json.put("traveller", traveller);
        HashMap<String, String> hotel = new HashMap<String, String>();
        hotel.put("name", "Meriton");
        json.put("hotel", hotel);
        HashMap<String, String> flight = new HashMap<String, String>();
        flight.put("flightNumber", "MX555");
        flight.put("arrival", "2019-08-20T22:12:57.340Z");
        flight.put("departure", "2019-08-20T07:12:57.340Z");
        json.put("flight", flight);
        return json;
    }

    private static ObjectNode getProcessInstanceVariablesJson() {
        return (ObjectNode)JsonUtils.getObjectMapper().valueToTree(TestUtils.getProcessInstanceVariablesMap());
    }

    public static UserTaskInstanceDataEvent getUserTaskCloudEvent(String taskId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId, String state) {
        return TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, rootProcessInstanceId, rootProcessId, state, "kogito");
    }

    public static UserTaskInstanceDataEvent getUserTaskCloudEvent(String taskId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId, String state, String actualOwner) {
        UserTaskInstanceEventBody body = UserTaskInstanceEventBody.create().id(taskId).state(state).taskName("TaskName").taskDescription("TaskDescription").taskPriority("High").actualOwner(actualOwner).startDate(new Date()).completeDate(Date.from(Instant.now().plus(1L, ChronoUnit.HOURS))).adminGroups(Collections.singleton("admin")).adminUsers(Collections.singleton("kogito")).excludedUsers(Collections.singleton("excluded")).potentialGroups(Collections.singleton("potentialGroup")).potentialUsers(Collections.singleton("potentialUser")).processInstanceId(processInstanceId).rootProcessInstanceId(rootProcessInstanceId).processId(processId).rootProcessId(rootProcessId).comments(Collections.singleton(TestUtils.getTaskComment("commentId" + taskId, "kogito", "Comment 1"))).attachments(Collections.singleton(TestUtils.getTaskAttachment("attachmentId" + taskId, "kogito", "http://linltodoc.com/1", "doc1"))).inputs(Collections.emptyMap()).outputs(Collections.emptyMap()).build();
        return new UserTaskInstanceDataEvent(URI.create("http://localhost:8080/" + processId).toString(), null, body.metaData(), body);
    }

    public static AttachmentEventBody getTaskAttachment(String id, String user, String name, String content) {
        return AttachmentEventBody.create().id(id).updatedBy(user).name(name).content(content == null ? null : URI.create(content)).updatedAt(new Date()).build();
    }

    public static CommentEventBody getTaskComment(String id, String user, String comment) {
        return CommentEventBody.create().id(id).content(comment).updatedBy(user).updatedAt(new Date()).build();
    }

    public static KogitoJobCloudEvent getJobCloudEvent(String jobId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId, String status) {
        return (KogitoJobCloudEvent)((KogitoJobCloudEvent.Builder)((KogitoJobCloudEvent.Builder)((KogitoJobCloudEvent.Builder)KogitoJobCloudEvent.builder().id(UUID.randomUUID().toString())).source(URI.create("http://localhost:8080/jobs"))).data((Object)TestUtils.getJob(jobId, processId, processInstanceId, rootProcessId, rootProcessInstanceId, status))).build();
    }

    public static Job getJob(String jobId, String processId, String processInstanceId, String rootProcessId, String rootProcessInstanceId, String status) {
        Job job = new Job();
        job.setId(jobId);
        job.setProcessId(processId);
        job.setProcessInstanceId(processInstanceId);
        job.setNodeInstanceId(UUID.randomUUID().toString());
        job.setRootProcessId(rootProcessId);
        job.setRootProcessInstanceId(rootProcessInstanceId);
        job.setStatus(status);
        job.setExpirationTime(ZonedDateTime.now());
        job.setPriority(Integer.valueOf(1));
        job.setCallbackEndpoint("http://service");
        job.setRepeatInterval(Long.valueOf(0L));
        job.setRepeatLimit(Integer.valueOf(-1));
        job.setScheduledId(UUID.randomUUID().toString());
        job.setRetries(Integer.valueOf(10));
        job.setLastUpdate(ZonedDateTime.now());
        job.setExecutionCounter(Integer.valueOf(2));
        return job;
    }

    public static UserTaskInstance getUserTaskInstance(String taskId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId, String state, String actualOwner) {
        UserTaskInstance task = new UserTaskInstance();
        task.setId(taskId);
        task.setProcessInstanceId(processInstanceId);
        task.setProcessId(processId);
        task.setRootProcessId(rootProcessId);
        task.setRootProcessInstanceId(rootProcessInstanceId);
        task.setName("TaskName");
        task.setDescription("TaskDescription");
        task.setState(state);
        task.setPriority("High");
        task.setStarted(ZonedDateTime.now());
        task.setCompleted(ZonedDateTime.now().plus(1L, ChronoUnit.HOURS));
        task.setActualOwner(actualOwner);
        task.setAdminUsers(Collections.singleton("kogito"));
        task.setAdminGroups(Collections.singleton("admin"));
        task.setExcludedUsers(Collections.singleton("excluded"));
        task.setPotentialUsers(Collections.singleton("potentialUser"));
        task.setPotentialGroups(Collections.singleton("potentialGroup"));
        task.setComments(List.of(Comment.builder().id("commentId" + taskId).content("Comment 1").updatedBy("kogito").build()));
        task.setAttachments(List.of(Attachment.builder().id("attachmentId" + taskId).content("http://linltodoc.com/1").name("doc1").updatedBy("kogito").build()));
        return task;
    }
}

