/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.BuilderHandler;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorIO;
import org.kie.internal.runtime.manager.deploy.TransientNamedObjectModel;
import org.kie.internal.runtime.manager.deploy.TransientObjectModel;

@XmlRootElement(name="deployment-descriptor")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DeploymentDescriptorImpl
implements DeploymentDescriptor,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="persistence-unit")
    @XmlSchemaType(name="string")
    private String persistenceUnit;
    @XmlElement(name="audit-persistence-unit")
    @XmlSchemaType(name="string")
    private String auditPersistenceUnit;
    @XmlElement(name="audit-mode")
    private AuditMode auditMode = AuditMode.JPA;
    @XmlElement(name="persistence-mode")
    private PersistenceMode persistenceMode = PersistenceMode.JPA;
    @XmlElement(name="runtime-strategy")
    private RuntimeStrategy runtimeStrategy = RuntimeStrategy.SINGLETON;
    @XmlElement(name="marshalling-strategy")
    @XmlElementWrapper(name="marshalling-strategies")
    private Set<ObjectModel> marshallingStrategies = new LinkedHashSet<ObjectModel>();
    @XmlElement(name="event-listener")
    @XmlElementWrapper(name="event-listeners")
    private Set<ObjectModel> eventListeners = new LinkedHashSet<ObjectModel>();
    @XmlElement(name="task-event-listener")
    @XmlElementWrapper(name="task-event-listeners")
    private List<ObjectModel> taskEventListeners = new ArrayList<ObjectModel>();
    @XmlElement(name="global")
    @XmlElementWrapper(name="globals")
    private Set<NamedObjectModel> globals = new LinkedHashSet<NamedObjectModel>();
    @XmlElement(name="work-item-handler")
    @XmlElementWrapper(name="work-item-handlers")
    private Set<NamedObjectModel> workItemHandlers = new LinkedHashSet<NamedObjectModel>();
    @XmlElement(name="environment-entry")
    @XmlElementWrapper(name="environment-entries")
    private Set<NamedObjectModel> environmentEntries = new LinkedHashSet<NamedObjectModel>();
    @XmlElement(name="configuration")
    @XmlElementWrapper(name="configurations")
    private Set<NamedObjectModel> configuration = new LinkedHashSet<NamedObjectModel>();
    @XmlElement(name="required-role")
    @XmlElementWrapper(name="required-roles")
    private Set<String> requiredRoles = new LinkedHashSet<String>();
    @XmlElement(name="remoteable-class")
    @XmlElementWrapper(name="remoteable-classes")
    private List<String> classes = new ArrayList<String>();
    @XmlElement(name="limit-serialization-classes")
    private Boolean limitSerializationClasses = true;
    @XmlTransient
    private Map<String, Set<String>> mappedRoles;

    protected void mapRequiredRoles() {
        if (this.mappedRoles != null) {
            return;
        }
        this.mappedRoles = new HashMap<String, Set<String>>();
        LinkedHashSet<String> typeAll = new LinkedHashSet<String>();
        LinkedHashSet<String> typeView = new LinkedHashSet<String>();
        LinkedHashSet<String> typeExecute = new LinkedHashSet<String>();
        this.mappedRoles.put("all", typeAll);
        this.mappedRoles.put("view", typeView);
        this.mappedRoles.put("execute", typeExecute);
        if (this.requiredRoles != null && !this.requiredRoles.isEmpty()) {
            Iterator<String> iterator = this.requiredRoles.iterator();
            while (iterator.hasNext()) {
                String roleString;
                String role = roleString = iterator.next();
                if (roleString.indexOf(":") != -1) {
                    String[] roleInfo = roleString.split(":");
                    String rolePrefix = roleInfo[0];
                    role = roleInfo[1];
                    this.mappedRoles.get(rolePrefix).add(role);
                    typeAll.add(role);
                    continue;
                }
                typeAll.add(role);
                typeView.add(role);
                typeExecute.add(role);
            }
        }
    }

    public DeploymentDescriptorImpl() {
    }

    public DeploymentDescriptorImpl(String defaultPU) {
        this.persistenceUnit = defaultPU;
        this.auditPersistenceUnit = defaultPU;
    }

    @Override
    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public String getAuditPersistenceUnit() {
        return this.auditPersistenceUnit;
    }

    @Override
    public AuditMode getAuditMode() {
        return this.auditMode;
    }

    @Override
    public PersistenceMode getPersistenceMode() {
        return this.persistenceMode;
    }

    @Override
    public RuntimeStrategy getRuntimeStrategy() {
        return this.runtimeStrategy;
    }

    @Override
    public List<ObjectModel> getMarshallingStrategies() {
        return new ArrayList<ObjectModel>(this.cleanSet(this.marshallingStrategies));
    }

    @Override
    public List<ObjectModel> getEventListeners() {
        return new ArrayList<ObjectModel>(this.cleanSet(this.eventListeners));
    }

    @Override
    public List<NamedObjectModel> getGlobals() {
        return new ArrayList<NamedObjectModel>(this.cleanNamedSet(this.globals));
    }

    @Override
    public List<NamedObjectModel> getWorkItemHandlers() {
        return new ArrayList<NamedObjectModel>(this.cleanNamedSet(this.workItemHandlers));
    }

    @Override
    public List<ObjectModel> getTaskEventListeners() {
        return new ArrayList<ObjectModel>(this.cleanList(this.taskEventListeners));
    }

    @Override
    public List<NamedObjectModel> getEnvironmentEntries() {
        return new ArrayList<NamedObjectModel>(this.cleanNamedSet(this.environmentEntries));
    }

    @Override
    public List<NamedObjectModel> getConfiguration() {
        return new ArrayList<NamedObjectModel>(this.cleanNamedSet(this.configuration));
    }

    @Override
    public List<String> getRequiredRoles() {
        return new ArrayList<String>(this.requiredRoles);
    }

    @Override
    public List<String> getRequiredRoles(String type) {
        this.mapRequiredRoles();
        Set<String> roles = this.mappedRoles.get(type);
        if (roles == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(roles);
    }

    @Override
    public List<String> getClasses() {
        if (this.classes == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.classes);
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public void setAuditPersistenceUnit(String auditPersistenceUnit) {
        this.auditPersistenceUnit = auditPersistenceUnit;
    }

    public void setAuditMode(AuditMode auditMode) {
        this.auditMode = auditMode;
    }

    public void setPersistenceMode(PersistenceMode persistenceMode) {
        this.persistenceMode = persistenceMode;
    }

    public void setRuntimeStrategy(RuntimeStrategy runtimeStrategy) {
        this.runtimeStrategy = runtimeStrategy;
    }

    public void setMarshallingStrategies(List<ObjectModel> marshallingStrategies) {
        if (marshallingStrategies != null) {
            this.marshallingStrategies = new HashSet<ObjectModel>(marshallingStrategies);
        }
    }

    public void setEventListeners(List<ObjectModel> eventListeners) {
        if (eventListeners != null) {
            this.eventListeners = new HashSet<ObjectModel>(eventListeners);
        }
    }

    public void setTaskEventListeners(List<ObjectModel> taskEventListeners) {
        if (taskEventListeners != null) {
            this.taskEventListeners = new ArrayList<ObjectModel>(taskEventListeners);
        }
    }

    public void setGlobals(List<NamedObjectModel> globals) {
        if (globals != null) {
            this.globals = new HashSet<NamedObjectModel>(globals);
        }
    }

    public void setWorkItemHandlers(List<NamedObjectModel> workItemHandlers) {
        if (workItemHandlers != null) {
            this.workItemHandlers = new HashSet<NamedObjectModel>(workItemHandlers);
        }
    }

    public void setEnvironmentEntries(List<NamedObjectModel> environmentEntires) {
        if (environmentEntires != null) {
            this.environmentEntries = new HashSet<NamedObjectModel>(environmentEntires);
        }
    }

    public void setConfiguration(List<NamedObjectModel> configuration) {
        if (configuration != null) {
            this.configuration = new HashSet<NamedObjectModel>(configuration);
        }
    }

    public void setRequiredRoles(List<String> requiredRoles) {
        if (requiredRoles != null) {
            this.requiredRoles = new HashSet<String>(requiredRoles);
        }
    }

    public void setClasses(List<String> classes) {
        if (classes != null) {
            this.classes = new ArrayList<String>(classes);
        }
    }

    @Override
    public Boolean getLimitSerializationClasses() {
        return this.limitSerializationClasses;
    }

    public void setLimitSerializationClasses(Boolean limitSerializationClasses) {
        this.limitSerializationClasses = limitSerializationClasses;
    }

    protected Set<NamedObjectModel> cleanNamedSet(Set<NamedObjectModel> input) {
        input.remove(null);
        return input;
    }

    protected Set<ObjectModel> cleanSet(Set<ObjectModel> input) {
        input.remove(null);
        return input;
    }

    protected List<ObjectModel> cleanList(List<ObjectModel> input) {
        while (input.remove(null)) {
        }
        return input;
    }

    protected void removeTransient(Collection<?> input) {
        Iterator<?> it = input.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof TransientNamedObjectModel) && !(object instanceof TransientObjectModel)) continue;
            it.remove();
        }
    }

    public DeploymentDescriptor clearClone() throws CloneNotSupportedException {
        DeploymentDescriptorImpl clone = new DeploymentDescriptorImpl();
        clone.getBuilder().setClasses(this.getClasses()).setConfiguration(this.getConfiguration()).setEnvironmentEntries(this.getEnvironmentEntries()).setEventListeners(this.getEventListeners()).setGlobals(this.getGlobals()).setMarshalingStrategies(this.getMarshallingStrategies()).setRequiredRoles(this.getRequiredRoles()).setTaskEventListeners(this.getTaskEventListeners()).setWorkItemHandlers(this.getWorkItemHandlers()).auditMode(this.getAuditMode()).auditPersistenceUnit(this.getAuditPersistenceUnit()).persistenceMode(this.getPersistenceMode()).persistenceUnit(this.getPersistenceUnit()).runtimeStrategy(this.getRuntimeStrategy()).setLimitSerializationClasses(this.getLimitSerializationClasses());
        this.removeTransient(clone.configuration);
        this.removeTransient(clone.environmentEntries);
        this.removeTransient(clone.eventListeners);
        this.removeTransient(clone.globals);
        this.removeTransient(clone.marshallingStrategies);
        this.removeTransient(clone.taskEventListeners);
        this.removeTransient(clone.workItemHandlers);
        return clone;
    }

    public boolean isEmpty() {
        boolean empty = true;
        if (this.persistenceUnit != null) {
            return false;
        }
        if (this.auditPersistenceUnit != null) {
            return false;
        }
        if (this.auditMode != AuditMode.JPA) {
            return false;
        }
        if (this.persistenceMode != PersistenceMode.JPA) {
            return false;
        }
        if (this.runtimeStrategy != RuntimeStrategy.SINGLETON) {
            return false;
        }
        if (this.marshallingStrategies != null && !this.marshallingStrategies.isEmpty()) {
            return false;
        }
        if (this.eventListeners != null && !this.eventListeners.isEmpty()) {
            return false;
        }
        if (this.taskEventListeners != null && !this.taskEventListeners.isEmpty()) {
            return false;
        }
        if (this.globals != null && !this.globals.isEmpty()) {
            return false;
        }
        if (this.workItemHandlers != null && !this.workItemHandlers.isEmpty()) {
            return false;
        }
        if (this.environmentEntries != null && !this.environmentEntries.isEmpty()) {
            return false;
        }
        if (this.configuration != null && !this.configuration.isEmpty()) {
            return false;
        }
        if (this.requiredRoles != null && !this.requiredRoles.isEmpty()) {
            return false;
        }
        if (this.classes != null && !this.classes.isEmpty()) {
            return false;
        }
        if (!this.limitSerializationClasses.booleanValue()) {
            return false;
        }
        return empty;
    }

    @Override
    public DeploymentDescriptorBuilder getBuilder() {
        return new DeploymentDescriptorBuilder(){
            private BuilderHandler handler = new BuilderHandler(){

                @Override
                public boolean accepted(Object value) {
                    return true;
                }
            };
            private DeploymentDescriptorImpl descriptor = DeploymentDescriptorImpl.this;

            @Override
            public DeploymentDescriptorBuilder runtimeStrategy(RuntimeStrategy strategy) {
                if (this.handler.accepted((Object)strategy)) {
                    this.descriptor.setRuntimeStrategy(strategy);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder persistenceUnit(String pu) {
                if (this.handler.accepted(pu)) {
                    this.descriptor.setPersistenceUnit(pu);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder persistenceMode(PersistenceMode mode) {
                if (this.handler.accepted((Object)mode)) {
                    this.descriptor.setPersistenceMode(mode);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder auditPersistenceUnit(String pu) {
                if (this.handler.accepted(pu)) {
                    this.descriptor.setAuditPersistenceUnit(pu);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder auditMode(AuditMode mode) {
                if (this.handler.accepted((Object)mode)) {
                    this.descriptor.setAuditMode(mode);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addWorkItemHandler(NamedObjectModel model) {
                if (this.handler.accepted(model) && !this.descriptor.workItemHandlers.add(model)) {
                    this.descriptor.workItemHandlers.remove(model);
                    this.descriptor.workItemHandlers.add(model);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addTaskEventListener(ObjectModel model) {
                if (this.handler.accepted(model) && !this.descriptor.taskEventListeners.contains(model)) {
                    this.descriptor.taskEventListeners.add(model);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addMarshalingStrategy(ObjectModel model) {
                if (this.handler.accepted(model) && !this.descriptor.marshallingStrategies.add(model)) {
                    this.descriptor.marshallingStrategies.remove(model);
                    this.descriptor.marshallingStrategies.add(model);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addGlobal(NamedObjectModel model) {
                if (this.handler.accepted(model) && !this.descriptor.globals.add(model)) {
                    this.descriptor.globals.remove(model);
                    this.descriptor.globals.add(model);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addEventListener(ObjectModel model) {
                if (this.handler.accepted(model) && !this.descriptor.eventListeners.add(model)) {
                    this.descriptor.eventListeners.remove(model);
                    this.descriptor.eventListeners.add(model);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addEnvironmentEntry(NamedObjectModel model) {
                if (this.handler.accepted(model) && !this.descriptor.environmentEntries.add(model)) {
                    this.descriptor.environmentEntries.remove(model);
                    this.descriptor.environmentEntries.add(model);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addConfiguration(NamedObjectModel model) {
                if (this.handler.accepted(model) && !this.descriptor.configuration.add(model)) {
                    this.descriptor.configuration.remove(model);
                    this.descriptor.configuration.add(model);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addRequiredRole(String role) {
                if (this.handler.accepted(role)) {
                    this.descriptor.requiredRoles.add(role);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder addClass(String clazz) {
                if (this.handler.accepted(clazz)) {
                    this.descriptor.classes.add(clazz);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setConfiguration(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setConfiguration(models);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setEnvironmentEntries(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setEnvironmentEntries(models);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setWorkItemHandlers(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setWorkItemHandlers(models);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setGlobals(List<NamedObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setGlobals(models);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setEventListeners(List<ObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setEventListeners(models);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setTaskEventListeners(List<ObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setTaskEventListeners(models);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setMarshalingStrategies(List<ObjectModel> models) {
                if (this.handler.accepted(models)) {
                    this.descriptor.setMarshallingStrategies(models);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setRequiredRoles(List<String> roles) {
                if (this.handler.accepted(roles)) {
                    this.descriptor.setRequiredRoles(roles);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setClasses(List<String> classes) {
                if (this.handler.accepted(classes)) {
                    this.descriptor.setClasses(classes);
                }
                return this;
            }

            @Override
            public DeploymentDescriptorBuilder setLimitSerializationClasses(Boolean limit) {
                if (this.handler.accepted(limit)) {
                    this.descriptor.setLimitSerializationClasses(limit);
                }
                return this;
            }

            @Override
            public void setBuildHandler(BuilderHandler handler) {
                this.handler = handler;
            }

            @Override
            public DeploymentDescriptor get() {
                return this.descriptor;
            }
        };
    }

    @Override
    public String toXml() {
        return DeploymentDescriptorIO.toXml(this);
    }

    public String toString() {
        return "DeploymentDescriptorImpl [\npersistenceUnit=" + this.persistenceUnit + "\nauditPersistenceUnit=" + this.auditPersistenceUnit + "\nauditMode=" + this.auditMode + "\npersistenceMode=" + this.persistenceMode + "\nruntimeStrategy=" + this.runtimeStrategy + "\nmarshallingStrategies=" + this.marshallingStrategies + "\neventListeners=" + this.eventListeners + "\ntaskEventListeners=" + this.taskEventListeners + "\nglobals=" + this.globals + "\nworkItemHandlers=" + this.workItemHandlers + "\nenvironmentEntries=" + this.environmentEntries + "\nconfiguration=" + this.configuration + "\nrequiredRoles=" + this.requiredRoles + "\nclasses=" + this.classes + "\nlimitSerializationClasses=" + this.limitSerializationClasses + "\nmappedRoles=" + this.mappedRoles + "]";
    }
}

