/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.sessions.AuthenticationSessionModel;

public abstract class BrowserHistoryHelper {
    public static final String SHOULD_UPDATE_BROWSER_HISTORY = "SHOULD_UPDATE_BROWSER_HISTORY";
    protected static final Logger logger = Logger.getLogger(BrowserHistoryHelper.class);

    public abstract Response saveResponseAndRedirect(KeycloakSession var1, AuthenticationSessionModel var2, Response var3, boolean var4, HttpRequest var5);

    public abstract Response loadSavedResponse(KeycloakSession var1, AuthenticationSessionModel var2);

    protected boolean shouldReplaceBrowserHistory(boolean actionRequest, HttpRequest httpRequest) {
        if (actionRequest) {
            return true;
        }
        Boolean flowChanged = (Boolean)httpRequest.getAttribute(SHOULD_UPDATE_BROWSER_HISTORY);
        return flowChanged != null && flowChanged != false;
    }

    public static BrowserHistoryHelper getInstance() {
        return new JavascriptHistoryReplace();
    }

    private static class NoOpHelper
    extends BrowserHistoryHelper {
        private NoOpHelper() {
        }

        @Override
        public Response saveResponseAndRedirect(KeycloakSession session, AuthenticationSessionModel authSession, Response response, boolean actionRequest, HttpRequest httpRequest) {
            return response;
        }

        @Override
        public Response loadSavedResponse(KeycloakSession session, AuthenticationSessionModel authSession) {
            return null;
        }
    }

    private static class RedirectAfterPostHelper
    extends BrowserHistoryHelper {
        private static final String CACHED_RESPONSE = "cached.response";

        private RedirectAfterPostHelper() {
        }

        @Override
        public Response saveResponseAndRedirect(KeycloakSession session, AuthenticationSessionModel authSession, Response response, boolean actionRequest, HttpRequest httpRequest) {
            Object entity;
            if (!this.shouldReplaceBrowserHistory(actionRequest, httpRequest)) {
                return response;
            }
            if (response.getStatus() == 200 && (entity = response.getEntity()) instanceof String) {
                String responseString = (String)entity;
                authSession.setAuthNote(CACHED_RESPONSE, responseString);
                URI lastExecutionURL = new AuthenticationFlowURLHelper(session, session.getContext().getRealm(), (UriInfo)session.getContext().getUri()).getLastExecutionUrl(authSession);
                if (logger.isTraceEnabled()) {
                    logger.tracef("Saved response challenge and redirect to %s", (Object)lastExecutionURL);
                }
                return Response.status((int)302).location(lastExecutionURL).build();
            }
            return response;
        }

        @Override
        public Response loadSavedResponse(KeycloakSession session, AuthenticationSessionModel authSession) {
            String savedResponse = authSession.getAuthNote(CACHED_RESPONSE);
            if (savedResponse != null) {
                authSession.removeAuthNote(CACHED_RESPONSE);
                if (logger.isTraceEnabled()) {
                    logger.tracef("Restored previously saved request", new Object[0]);
                }
                Response.ResponseBuilder builder = Response.status((int)200).type("text/html; charset=utf-8").entity((Object)savedResponse);
                return builder.build();
            }
            return null;
        }
    }

    private static class JavascriptHistoryReplace
    extends BrowserHistoryHelper {
        private static final Pattern HEAD_END_PATTERN = Pattern.compile("</[hH][eE][aA][dD]>");

        private JavascriptHistoryReplace() {
        }

        @Override
        public Response saveResponseAndRedirect(KeycloakSession session, AuthenticationSessionModel authSession, Response response, boolean actionRequest, HttpRequest httpRequest) {
            if (!this.shouldReplaceBrowserHistory(actionRequest, httpRequest)) {
                return response;
            }
            Object entity = response.getEntity();
            if (entity != null && entity instanceof String) {
                String responseString = (String)entity;
                URI lastExecutionURL = new AuthenticationFlowURLHelper(session, session.getContext().getRealm(), (UriInfo)session.getContext().getUri()).getLastExecutionUrl(authSession);
                String responseWithJavascript = this.responseWithJavascript(responseString, lastExecutionURL.toString());
                return Response.fromResponse((Response)response).entity((Object)responseWithJavascript).build();
            }
            return response;
        }

        @Override
        public Response loadSavedResponse(KeycloakSession session, AuthenticationSessionModel authSession) {
            return null;
        }

        private String responseWithJavascript(String origHtml, String lastExecutionUrl) {
            Matcher m = HEAD_END_PATTERN.matcher(origHtml);
            if (m.find()) {
                int start = m.start();
                String javascript = this.getJavascriptText(lastExecutionUrl);
                return origHtml.substring(0, start) + javascript + origHtml.substring(start);
            }
            return origHtml;
        }

        private String getJavascriptText(String lastExecutionUrl) {
            return "<SCRIPT>" + " if (typeof history.replaceState === 'function') {" + ("  history.replaceState({}, \"some title\", \"" + lastExecutionUrl + "\");") + " }" + "</SCRIPT>";
        }
    }
}

