/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.crypto.CekManagementProvider;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.alg.RsaKeyEncryption256JWEAlgorithmProvider;
import org.keycloak.jose.jwe.alg.RsaKeyEncryptionJWEAlgorithmProvider;
import org.keycloak.models.KeycloakSession;

public class RsaCekManagementProvider
implements CekManagementProvider {
    private final KeycloakSession session;
    private final String jweAlgorithmName;

    public RsaCekManagementProvider(KeycloakSession session, String jweAlgorithmName) {
        this.session = session;
        this.jweAlgorithmName = jweAlgorithmName;
    }

    public JWEAlgorithmProvider jweAlgorithmProvider() {
        String jcaAlgorithmName = null;
        if ("RSA1_5".equals(this.jweAlgorithmName)) {
            jcaAlgorithmName = "RSA/ECB/PKCS1Padding";
        } else if ("RSA-OAEP".equals(this.jweAlgorithmName)) {
            jcaAlgorithmName = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
        } else if ("RSA-OAEP-256".equals(this.jweAlgorithmName)) {
            return new RsaKeyEncryption256JWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
        }
        return new RsaKeyEncryptionJWEAlgorithmProvider(jcaAlgorithmName);
    }
}

