/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.DisplayTypeAuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.KeycloakSession;

public interface ConditionalAuthenticatorFactory
extends AuthenticatorFactory,
DisplayTypeAuthenticatorFactory {
    public static final String REFERENCE_CATEGORY = "condition";

    default public Authenticator create(KeycloakSession session) {
        return this.getSingleton();
    }

    default public Authenticator createDisplay(KeycloakSession session, String displayType) {
        if (displayType == null) {
            return this.create(session);
        }
        if (!"console".equalsIgnoreCase(displayType)) {
            return null;
        }
        return this.create(session);
    }

    default public String getReferenceCategory() {
        return REFERENCE_CATEGORY;
    }

    public ConditionalAuthenticator getSingleton();
}

