/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.elytron.KeycloakHttpServerAuthenticationMechanism;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public class KeycloakHttpServerAuthenticationMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final SessionIdMapper idMapper = new InMemorySessionIdMapper();
    private final SamlDeploymentContext deploymentContext;

    public KeycloakHttpServerAuthenticationMechanismFactory() {
        this(null);
    }

    public KeycloakHttpServerAuthenticationMechanismFactory(SamlDeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
    }

    public String[] getMechanismNames(Map<String, ?> properties) {
        return new String[]{"KEYCLOAK-SAML"};
    }

    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        HashMap mechanismProperties = new HashMap();
        mechanismProperties.putAll(properties);
        if ("KEYCLOAK-SAML".equals(mechanismName)) {
            KeycloakHttpServerAuthenticationMechanism mech = new KeycloakHttpServerAuthenticationMechanism(properties, callbackHandler, this.deploymentContext, this.idMapper, SessionIdMapperUpdater.DIRECT);
            return mech;
        }
        return null;
    }
}

