/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.entities.PolicyQuery;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;

public class PolicyListQuery
extends AbstractRevisioned
implements PolicyQuery {
    private final Set<String> policies;
    private final String serverId;

    public PolicyListQuery(Long revision, String id, String policyId, String serverId) {
        super(revision, id);
        this.serverId = serverId;
        this.policies = new HashSet<String>();
        this.policies.add(policyId);
    }

    public PolicyListQuery(Long revision, String id, Set<String> policies, String serverId) {
        super(revision, id);
        this.serverId = serverId;
        this.policies = policies;
    }

    @Override
    public String getResourceServerId() {
        return this.serverId;
    }

    @Override
    public Set<String> getPolicies() {
        return this.policies;
    }

    @Override
    public boolean isInvalid(Set<String> invalidations) {
        return invalidations.contains(this.getId()) || invalidations.contains(this.getResourceServerId());
    }
}

