/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public class ThrowableCollector {
    private Throwable throwable;

    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable t) {
            this.add(t);
        }
    }

    private void add(Throwable t) {
        Preconditions.notNull((Object)t, (String)"Throwable must not be null");
        if (this.throwable == null) {
            this.throwable = t;
        } else {
            this.throwable.addSuppressed(t);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isEmpty() {
        return this.throwable == null;
    }

    public boolean isNotEmpty() {
        return this.throwable != null;
    }

    public void assertEmpty() {
        if (!this.isEmpty()) {
            ExceptionUtils.throwAsUncheckedException((Throwable)this.throwable);
        }
    }
}

