/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public class TestTemplateTestDescriptor
extends MethodBasedTestDescriptor {
    public TestTemplateTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod) {
        super(uniqueId, testClass, templateMethod);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean mayRegisterTests() {
        return true;
    }

    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) throws Exception {
        ExtensionRegistry registry = this.populateNewExtensionRegistryFromExtendWith(this.getTestMethod(), context.getExtensionRegistry());
        Object testInstance = context.getExtensionContext().getTestInstance().orElse(null);
        TestTemplateExtensionContext extensionContext = new TestTemplateExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, testInstance);
        return context.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).build();
    }

    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ExtensionContext extensionContext = context.getExtensionContext();
        List<TestTemplateInvocationContextProvider> providers = this.validateProviders(extensionContext, context.getExtensionRegistry());
        AtomicInteger invocationIndex = new AtomicInteger();
        providers.stream().flatMap(provider -> provider.provideTestTemplateInvocationContexts(extensionContext)).map(invocationContext -> this.createInvocationTestDescriptor((TestTemplateInvocationContext)invocationContext, invocationIndex.incrementAndGet())).forEach(invocationTestDescriptor -> this.execute(dynamicTestExecutor, (TestDescriptor)invocationTestDescriptor));
        this.validateWasAtLeastInvokedOnce(invocationIndex.get());
        return context;
    }

    private List<TestTemplateInvocationContextProvider> validateProviders(ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        List providers = extensionRegistry.stream(TestTemplateInvocationContextProvider.class).filter(provider -> provider.supportsTestTemplate(extensionContext)).collect(Collectors.toList());
        return (List)Preconditions.notEmpty(providers, () -> String.format("You must register at least one %s that supports @TestTemplate method [%s]", TestTemplateInvocationContextProvider.class.getSimpleName(), this.getTestMethod()));
    }

    private TestDescriptor createInvocationTestDescriptor(TestTemplateInvocationContext invocationContext, int index) {
        UniqueId uniqueId = this.getUniqueId().append("test-template-invocation", "#" + index);
        return new TestTemplateInvocationTestDescriptor(uniqueId, this.getTestClass(), this.getTestMethod(), invocationContext, index);
    }

    private void execute(Node.DynamicTestExecutor dynamicTestExecutor, TestDescriptor testDescriptor) {
        this.addChild(testDescriptor);
        dynamicTestExecutor.execute(testDescriptor);
    }

    private void validateWasAtLeastInvokedOnce(int invocationIndex) {
        Preconditions.condition((invocationIndex > 0 ? 1 : 0) != 0, () -> "No supporting " + TestTemplateInvocationContextProvider.class.getSimpleName() + " provided an invocation context");
    }
}

