/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.opentest4j.AssertionFailedError;

class AssertThrows {
    private AssertThrows() {
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable) {
        return AssertThrows.assertThrows(expectedType, AssertThrows.asSupplier(executable), null);
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, String message) {
        return AssertThrows.assertThrows(expectedType, AssertThrows.asSupplier(executable), (Object)message);
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, Supplier<String> messageSupplier) {
        return AssertThrows.assertThrows(expectedType, AssertThrows.asSupplier(executable), messageSupplier);
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, ThrowingSupplier<?> supplier) {
        return AssertThrows.assertThrows(expectedType, supplier::get, null);
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, ThrowingSupplier<?> supplier, String message) {
        return AssertThrows.assertThrows(expectedType, supplier::get, (Object)message);
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, ThrowingSupplier<?> supplier, Supplier<String> messageSupplier) {
        return AssertThrows.assertThrows(expectedType, supplier::get, messageSupplier);
    }

    private static <T extends Throwable> T assertThrows(Class<T> expectedType, ResultAwareThrowingSupplier<?> supplier, Object messageOrSupplier) {
        Object result;
        try {
            result = supplier.get();
        }
        catch (Throwable actualException) {
            if (expectedType.isInstance(actualException)) {
                return (T)actualException;
            }
            String message = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + AssertionUtils.format(expectedType, actualException.getClass(), "Unexpected exception type thrown");
            throw new AssertionFailedError(message, actualException);
        }
        String message = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + String.format("Expected %s to be thrown, but nothing was thrown", AssertionUtils.getCanonicalName(expectedType)) + (supplier.includeResult() ? String.format(" (returned %s).", result) : ".");
        throw new AssertionFailedError(message);
    }

    private static ResultAwareThrowingSupplier<Void> asSupplier(final Executable executable) {
        return new ResultAwareThrowingSupplier<Void>(){

            @Override
            public Void get() throws Throwable {
                executable.execute();
                return null;
            }

            @Override
            public boolean includeResult() {
                return false;
            }
        };
    }

    private static interface ResultAwareThrowingSupplier<T>
    extends ThrowingSupplier<T> {
        default public boolean includeResult() {
            return true;
        }
    }
}

