/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;

public class LocalOptimizationPass
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Local Optimizations";
    }

    @Override
    public Object execute(IRScope s2, Object ... data2) {
        for (BasicBlock b2 : s2.getCFG().getBasicBlocks()) {
            LocalOptimizationPass.runLocalOptsOnBasicBlock(s2, b2);
        }
        s2.computeScopeFlags();
        new LiveVariableAnalysis().invalidate(s2);
        return null;
    }

    private static void recordSimplification(Variable res, Operand val, Map<Operand, Operand> valueMap, Map<Variable, List<Variable>> simplificationMap) {
        valueMap.put(res, val);
        ArrayList<Variable> valVars = new ArrayList<Variable>();
        val.addUsedVariables(valVars);
        for (Variable v : valVars) {
            List<Variable> x = simplificationMap.get(v);
            if (x == null) {
                x = new ArrayList<Variable>();
                simplificationMap.put(v, x);
            }
            x.add(res);
        }
    }

    public static Instr optInstr(IRScope s2, Instr instr, Map<Operand, Operand> valueMap, Map<Variable, List<Variable>> simplificationMap) {
        List<Variable> simplifiedVars;
        Operand val = instr.simplifyAndGetResult(s2, valueMap);
        if (!(instr instanceof ResultInstr)) {
            return instr;
        }
        Instr newInstr = instr;
        Variable res = ((ResultInstr)((Object)instr)).getResult();
        if (val == null) {
            valueMap.remove(res);
        } else {
            if (!res.equals(val)) {
                LocalOptimizationPass.recordSimplification(res, val, valueMap, simplificationMap);
            }
            if (!instr.hasSideEffects()) {
                if (instr instanceof CopyInstr) {
                    if (res.equals(val) && instr.canBeDeleted(s2)) {
                        System.out.println("DEAD: marking instr dead!!");
                        instr.markDead();
                    }
                } else {
                    newInstr = new CopyInstr(res, val);
                }
            }
        }
        if (!res.equals(val) && (simplifiedVars = simplificationMap.get(res)) != null) {
            for (Variable v : simplifiedVars) {
                valueMap.remove(v);
            }
            simplificationMap.remove(res);
        }
        return newInstr;
    }

    public static void runLocalOptsOnInstrArray(IRScope s2, Instr[] instrs) {
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<Variable, List<Variable>> simplificationMap = new HashMap<Variable, List<Variable>>();
        for (int i2 = 0; i2 < instrs.length; ++i2) {
            Operation iop;
            Instr instr = instrs[i2];
            Instr newInstr = LocalOptimizationPass.optInstr(s2, instr, valueMap, simplificationMap);
            if (newInstr != instr) {
                instrs[i2] = newInstr;
            }
            if (!(iop = instr.getOperation()).startsBasicBlock() && !iop.endsBasicBlock() && (!iop.isCall() || instr.isDead())) continue;
            valueMap = new HashMap();
            simplificationMap = new HashMap();
        }
    }

    public static void runLocalOptsOnBasicBlock(IRScope s2, BasicBlock b2) {
        ListIterator<Instr> instrs = b2.getInstrs().listIterator();
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<Variable, List<Variable>> simplificationMap = new HashMap<Variable, List<Variable>>();
        while (instrs.hasNext()) {
            Operation iop;
            Instr instr = instrs.next();
            Instr newInstr = LocalOptimizationPass.optInstr(s2, instr, valueMap, simplificationMap);
            if (newInstr.isDead()) {
                instrs.remove();
            } else if (newInstr != instr) {
                instrs.set(newInstr);
            }
            if (!(iop = instr.getOperation()).isCall() || instr.isDead()) continue;
            valueMap = new HashMap();
            simplificationMap = new HashMap();
        }
    }
}

