/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DynamicSymbol
extends Operand {
    private final Operand symbolName;

    public DynamicSymbol(Operand n) {
        super(OperandType.DYNAMIC_SYMBOL);
        this.symbolName = n;
    }

    public Operand getSymbolName() {
        return this.symbolName;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newSymbol = this.symbolName.getSimplifiedOperand(valueMap, force);
        return this.symbolName == newSymbol ? this : new DynamicSymbol(newSymbol);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.symbolName.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        Operand clonedSymbolName = this.symbolName.cloneForInlining(ii);
        return clonedSymbolName == this.symbolName ? this : new DynamicSymbol(clonedSymbolName);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        IRubyObject obj = (IRubyObject)this.symbolName.retrieve(context, self2, currScope, currDynScope, temp);
        String str = obj.asJavaString();
        Encoding encoding2 = obj.asString().getByteList().getEncoding();
        return context.runtime.newSymbol(str, encoding2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DynamicSymbol(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.symbolName);
    }

    public static DynamicSymbol decode(IRReaderDecoder d) {
        return new DynamicSymbol(d.decodeOperand());
    }

    public String toString() {
        return ":" + this.symbolName.toString();
    }
}

