/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class GetClassVarContainerModuleInstr
extends ResultBaseInstr
implements FixedArityInstr {
    public GetClassVarContainerModuleInstr(Variable result2, Operand startingScope, Variable object) {
        Operand[] operandArray;
        if (object == null) {
            Operand[] operandArray2 = new Operand[1];
            operandArray = operandArray2;
            operandArray2[0] = startingScope;
        } else {
            Operand[] operandArray3 = new Operand[2];
            operandArray3[0] = startingScope;
            operandArray = operandArray3;
            operandArray3[1] = object;
        }
        super(Operation.CLASS_VAR_MODULE, result2, operandArray);
        assert (result2 != null);
    }

    public Variable getObject() {
        return (Variable)(this.operands.length >= 2 ? this.operands[1] : null);
    }

    public Operand getStartingScope() {
        return this.operands[0];
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new GetClassVarContainerModuleInstr(ii.getRenamedVariable(this.result), this.getStartingScope().cloneForInlining(ii), this.getObject() == null ? null : (Variable)this.getObject().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getStartingScope());
        e.encode(this.getObject());
    }

    public static GetClassVarContainerModuleInstr decode(IRReaderDecoder d) {
        return new GetClassVarContainerModuleInstr(d.decodeVariable(), d.decodeOperand(), d.decodeVariable());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        StaticScope scope = (StaticScope)this.getStartingScope().retrieve(context, self2, currScope, currDynScope, temp);
        Variable object = this.getObject();
        IRubyObject arg2 = object == null ? null : (IRubyObject)object.retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.getModuleFromScope(context, scope, arg2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.GetClassVarContainerModuleInstr(this);
    }
}

