/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Helpers;

public class ArgsNode
extends Node {
    private final ListNode pre;
    private final ListNode optArgs;
    protected final ArgumentNode restArgNode;
    private final ListNode post;
    private final ListNode keywords;
    private final KeywordRestArgNode keyRest;
    private final BlockArgNode blockArgNode;

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest2, ListNode post, BlockArgNode blockArgNode) {
        this(position, pre, optionalArguments, rest2, post, null, null, blockArgNode);
    }

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest2, ListNode post, ListNode keywords, KeywordRestArgNode keyRest, BlockArgNode blockArgNode) {
        super(position, pre != null && pre.containsVariableAssignment() || optionalArguments != null && optionalArguments.containsVariableAssignment() || rest2 != null && rest2.containsVariableAssignment() || post != null && post.containsVariableAssignment() || keywords != null && keywords.containsVariableAssignment() || keyRest != null && keyRest.containsVariableAssignment() || blockArgNode != null && blockArgNode.containsVariableAssignment());
        this.pre = pre;
        this.post = post;
        this.optArgs = optionalArguments;
        this.restArgNode = rest2;
        this.blockArgNode = blockArgNode;
        this.keywords = keywords;
        this.keyRest = keyRest;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    public boolean hasKwargs() {
        return this.keywords != null || this.keyRest != null;
    }

    public int countKeywords() {
        if (this.hasKwargs()) {
            if (this.keywords == null) {
                return 0;
            }
            return this.keywords.size();
        }
        return 0;
    }

    public boolean hasRestArg() {
        return this.restArgNode != null;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getRequiredArgsCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public int getOptionalArgsCount() {
        return this.optArgs == null ? 0 : this.optArgs.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    public int getMaxArgumentsCount() {
        return this.hasRestArg() ? -1 : this.getRequiredArgsCount() + this.getOptionalArgsCount();
    }

    public ListNode getOptArgs() {
        return this.optArgs;
    }

    public ArgumentNode getRestArgNode() {
        return this.restArgNode;
    }

    public BlockArgNode getBlock() {
        return this.blockArgNode;
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public ListNode getKeywords() {
        return this.keywords;
    }

    public KeywordRestArgNode getKeyRest() {
        return this.keyRest;
    }

    public boolean hasKeyRest() {
        return this.keyRest != null;
    }

    @Override
    public List<Node> childNodes() {
        if (this.post != null) {
            if (this.keywords != null) {
                if (this.keyRest != null) {
                    return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.keywords, this.keyRest, this.blockArgNode);
                }
                return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.keywords, this.blockArgNode);
            }
            return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.blockArgNode);
        }
        if (this.keywords != null) {
            if (this.keyRest != null) {
                return Node.createList(this.pre, this.optArgs, this.restArgNode, this.keywords, this.keyRest, this.blockArgNode);
            }
            return Node.createList(this.pre, this.optArgs, this.restArgNode, this.keywords, this.blockArgNode);
        }
        return Node.createList(this.pre, this.optArgs, this.restArgNode, this.blockArgNode);
    }

    public int getKeywordCount() {
        return this.keywords == null ? 0 : this.keywords.size();
    }

    public int getRequiredKeywordCount() {
        if (this.keywords == null) {
            return 0;
        }
        int count2 = 0;
        for (Node keyWordNode : this.getKeywords().children()) {
            for (Node asgnNode : keyWordNode.childNodes()) {
                if (!Helpers.isRequiredKeywordArgumentValueNode(asgnNode)) continue;
                ++count2;
            }
        }
        return count2;
    }
}

