/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jruby.util.cli.BooleanOption;
import org.jruby.util.cli.EnumerationOption;
import org.jruby.util.cli.IntegerOption;
import org.jruby.util.cli.StringOption;

public abstract class Option<T> {
    private static Comparator<Option> OptionComparator = new Comparator<Option>(){

        @Override
        public int compare(Option o1, Option o2) {
            int catComp = o1.category.compareTo(o2.category);
            if (catComp != 0) {
                return catComp;
            }
            return o1.displayName.compareTo(o2.displayName);
        }
    };
    public final Enum category;
    public final String prefix;
    public final String name;
    public final String longName;
    public final String displayName;
    public final Class<T> type;
    public final Object[] options;
    public final T defval;
    public final String description;
    public T value;
    private boolean specified;

    public Option(String prefix, String name2, Class<T> type2, Enum category, T[] options2, T defval, String description) {
        Object[] objectArray;
        this.category = category;
        this.prefix = prefix;
        this.name = name2;
        this.longName = prefix + "." + name2;
        this.displayName = name2;
        this.type = type2;
        if (options2 == null) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = type2.getSimpleName();
        } else {
            objectArray = options2;
        }
        this.options = objectArray;
        this.defval = defval;
        this.description = description;
        this.specified = false;
    }

    public Option(String longName, Class<T> type2, Enum category, T[] options2, T defval, String description) {
        Object[] objectArray;
        this.category = category;
        this.prefix = null;
        this.name = null;
        this.longName = longName;
        this.displayName = longName;
        this.type = type2;
        if (options2 == null) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = type2.getSimpleName();
        } else {
            objectArray = options2;
        }
        this.options = objectArray;
        this.defval = defval;
        this.description = description;
        this.specified = false;
    }

    public static Option<String> string(String prefix, String name2, Enum category, String description) {
        return new StringOption(prefix, name2, category, null, null, description);
    }

    public static Option<String> string(String longName, Enum category, String description) {
        return new StringOption(longName, category, null, null, description);
    }

    public static Option<String> string(String prefix, String name2, Enum category, String defval, String description) {
        return new StringOption(prefix, name2, category, null, defval, description);
    }

    public static Option<String> string(String longName, Enum category, String defval, String description) {
        return new StringOption(longName, category, null, defval, description);
    }

    public static Option<String> string(String prefix, String name2, Enum category, String[] options2, String description) {
        return new StringOption(prefix, name2, category, options2, null, description);
    }

    public static Option<String> string(String longName, Enum category, String[] options2, String description) {
        return new StringOption(longName, category, options2, null, description);
    }

    public static Option<String> string(String prefix, String name2, Enum category, String[] options2, String defval, String description) {
        return new StringOption(prefix, name2, category, options2, defval, description);
    }

    public static Option<String> string(String longName, Enum category, String[] options2, String defval, String description) {
        return new StringOption(longName, category, options2, defval, description);
    }

    public static Option<Boolean> bool(String prefix, String name2, Enum category, String description) {
        return new BooleanOption(prefix, name2, category, null, description);
    }

    public static Option<Boolean> bool(String longName, Enum category, String description) {
        return new BooleanOption(longName, category, null, description);
    }

    public static Option<Boolean> bool(String prefix, String name2, Enum category, Boolean defval, String description) {
        return new BooleanOption(prefix, name2, category, defval, description);
    }

    public static Option<Boolean> bool(String longName, Enum category, Boolean defval, String description) {
        return new BooleanOption(longName, category, defval, description);
    }

    public static Option<Integer> integer(String prefix, String name2, Enum category, String description) {
        return new IntegerOption(prefix, name2, category, null, description);
    }

    public static Option<Integer> integer(String longName, Enum category, String description) {
        return new IntegerOption(longName, category, null, description);
    }

    public static Option<Integer> integer(String prefix, String name2, Enum category, Integer defval, String description) {
        return new IntegerOption(prefix, name2, category, defval, description);
    }

    public static Option<Integer> integer(String longName, Enum category, Integer defval, String description) {
        return new IntegerOption(longName, category, defval, description);
    }

    public static Option<Integer> integer(String prefix, String name2, Enum category, Integer[] options2, Integer defval, String description) {
        return new IntegerOption(prefix, name2, category, options2, defval, description);
    }

    public static Option<Integer> integer(String longName, Enum category, Integer[] options2, Integer defval, String description) {
        return new IntegerOption(longName, category, options2, defval, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String prefix, String name2, Enum category, Class<T> enumClass, String description) {
        return new EnumerationOption<Object>(prefix, name2, category, enumClass, null, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String longName, Enum category, Class<T> enumClass, String description) {
        return new EnumerationOption<Object>(longName, category, enumClass, null, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String prefix, String name2, Enum category, Class<T> enumClass, T defval, String description) {
        return new EnumerationOption<T>(prefix, name2, category, enumClass, defval, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String longName, Enum category, Class<T> enumClass, T defval, String description) {
        return new EnumerationOption<T>(longName, category, enumClass, defval, description);
    }

    public static String formatValues(Collection<Option> options2) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Option> sorted = new ArrayList<Option>(options2);
        Collections.sort(sorted, OptionComparator);
        Enum category = null;
        for (Option option : sorted) {
            if (category != option.category) {
                category = option.category;
                sb.append('\n').append(category).append('\n');
            }
            sb.append(option.displayName).append('=').append(Option.encodeWhitespace(option.load())).append('\n');
        }
        return sb.toString();
    }

    public static String formatOptions(Collection<Option> options2) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Option> sorted = new ArrayList<Option>(options2);
        Collections.sort(sorted, OptionComparator);
        Enum category = null;
        for (Option option : sorted) {
            if (category != option.category) {
                category = option.category;
                sb.append("\n################################################################################");
                sb.append("\n# ").append(category);
                sb.append("\n################################################################################\n\n");
            }
            sb.append("# ").append(option.description).append('\n');
            sb.append("# Options: ").append(Arrays.toString(option.options)).append(", Default: ").append(Option.encodeWhitespace(option.defval)).append(".\n");
            sb.append("\n#");
            sb.append(option.displayName).append('=').append(Option.outputForValue(option.load()));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    private static String encodeWhitespace(Object obj) {
        if (obj == null) {
            return "null";
        }
        String str = obj.toString();
        StringBuilder sb = new StringBuilder(str.length() * 2);
        boolean hasWhitespace = false;
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) {
                hasWhitespace = true;
                switch (c) {
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        if (hasWhitespace) {
            return "\"" + sb.toString() + "\"";
        }
        return str;
    }

    private static String outputForValue(Object obj) {
        if (obj == null) {
            return "";
        }
        return Option.encodeWhitespace(obj);
    }

    public String toString() {
        return this.longName;
    }

    public String loadProperty() {
        String value2 = null;
        try {
            value2 = System.getProperty(this.longName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (value2 != null) {
            this.specified = true;
        }
        return value2;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public T load() {
        if (this.value != null) {
            return this.value;
        }
        this.value = this.reload();
        return this.value;
    }

    public abstract T reload();
}

