/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ASTInspector;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.EmbedEvalUnitImpl;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedRubyRuntimeAdapterImpl
implements EmbedRubyRuntimeAdapter {
    private final RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
    private final ScriptingContainer container;

    public EmbedRubyRuntimeAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    @Override
    public EmbedEvalUnit parse(String script, int ... lines2) {
        if (script == null) {
            return null;
        }
        boolean unicode_escape = false;
        Object obj = this.container.getAttribute((Object)AttributeName.UNICODE_ESCAPE);
        if (obj != null && obj instanceof Boolean) {
            unicode_escape = (Boolean)obj;
        }
        if (unicode_escape) {
            ReaderInputStream istream = new ReaderInputStream(new StringReader(script));
            return this.runParser(istream, null, lines2);
        }
        return this.runParser(script, null, lines2);
    }

    @Override
    public EmbedEvalUnit parse(Reader reader, String filename2, int ... lines2) {
        if (reader != null) {
            ReaderInputStream istream = new ReaderInputStream(reader);
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    @Override
    public EmbedEvalUnit parse(PathType type2, String filename2, int ... lines2) {
        if (filename2 == null) {
            return null;
        }
        if (type2 == null) {
            type2 = PathType.ABSOLUTE;
        }
        InputStream istream = null;
        try {
            Object basedir;
            switch (type2) {
                case ABSOLUTE: {
                    istream = new FileInputStream(filename2);
                    break;
                }
                case RELATIVE: {
                    basedir = (String)this.container.getAttribute((Object)AttributeName.BASE_DIR);
                    if (basedir == null) {
                        basedir = SystemPropertyCatcher.getBaseDir();
                    }
                    String absolutePath = (String)basedir + File.separator + filename2;
                    istream = new FileInputStream(absolutePath);
                    break;
                }
                case CLASSPATH: {
                    URL loc = this.container.getProvider().getRuntime().getJRubyClassLoader().getResource(filename2);
                    if (loc == null) {
                        istream = null;
                        break;
                    }
                    filename2 = LoadService.classpathFilenameFromURL(filename2, loc, true);
                    try {
                        istream = loc.openStream();
                        break;
                    }
                    catch (IOException ioe) {
                        istream = null;
                    }
                }
            }
            basedir = this.parse(istream, filename2, lines2);
            return basedir;
        }
        catch (FileNotFoundException e) {
            throw new ParseFailedException(e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @Override
    public EmbedEvalUnit parse(InputStream istream, String filename2, int ... lines2) {
        if (istream != null) {
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    private EmbedEvalUnit runParser(Object input, String filename2, int ... lines2) {
        if (input == null) {
            return null;
        }
        if (filename2 == null || filename2.length() == 0) {
            filename2 = this.container.getScriptFilename();
        }
        Ruby runtime = this.container.getProvider().getRuntime();
        ValueAccessor $0 = new ValueAccessor(RubyString.newString(runtime, filename2));
        runtime.getGlobalVariables().define("$PROGRAM_NAME", $0, GlobalVariable.Scope.GLOBAL);
        runtime.getGlobalVariables().define("$0", $0, GlobalVariable.Scope.GLOBAL);
        int line = 0;
        if (lines2 != null && lines2.length > 0) {
            line = lines2[0];
        }
        try {
            ManyVarsDynamicScope scope = null;
            boolean sharing_variables = true;
            Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
            if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                sharing_variables = false;
            }
            if (sharing_variables) {
                scope = EmbedRubyRuntimeAdapterImpl.getManyVarsDynamicScope(this.container, 0);
            }
            Node node = input instanceof String ? runtime.parseEval((String)input, filename2, (DynamicScope)scope, line) : runtime.parseFile((InputStream)input, filename2, scope, line);
            RubyInstanceConfig.CompileMode compileMode = runtime.getInstanceConfig().getCompileMode();
            if (compileMode == RubyInstanceConfig.CompileMode.FORCE) {
                ASTInspector inspector = new ASTInspector();
                inspector.setFlag(ASTInspector.SCOPE_AWARE);
                Script script = runtime.tryCompile(node, inspector);
                if (script != null) {
                    EmbedEvalUnitImpl embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope, script);
                    return embedEvalUnitImpl;
                }
                EmbedEvalUnitImpl embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope);
                return embedEvalUnitImpl;
            }
            EmbedEvalUnitImpl embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope);
            return embedEvalUnitImpl;
        }
        catch (RaiseException e) {
            runtime.printError(e.getException());
            throw new ParseFailedException(e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new ParseFailedException(e);
        }
        finally {
            try {
                if (input instanceof InputStream) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException ex) {
                throw new ParseFailedException(ex);
            }
        }
    }

    static ManyVarsDynamicScope getManyVarsDynamicScope(ScriptingContainer container, int depth) {
        StaticScopeFactory scopeFactory = container.getProvider().getRuntime().getStaticScopeFactory();
        StaticScope topStaticScope = scopeFactory.newLocalScope(null);
        topStaticScope.setModule(container.getProvider().getRuntime().getObject());
        ManyVarsDynamicScope currentScope = new ManyVarsDynamicScope(topStaticScope, null);
        String[] names4Injection = container.getVarMap().getLocalVarNames();
        StaticScope evalScope = names4Injection == null || names4Injection.length == 0 ? scopeFactory.newEvalScope(currentScope.getStaticScope()) : scopeFactory.newEvalScope(currentScope.getStaticScope(), names4Injection);
        ManyVarsDynamicScope scope = new ManyVarsDynamicScope(evalScope, currentScope);
        scope.getStaticScope().determineModule();
        return scope;
    }

    @Override
    public IRubyObject eval(Ruby runtime, String script) {
        return this.adapter.eval(runtime, script);
    }

    @Override
    public JavaEmbedUtils.EvalUnit parse(Ruby runtime, String script, String filename2, int lineNumber) {
        return this.adapter.parse(runtime, script, filename2, lineNumber);
    }

    @Override
    public JavaEmbedUtils.EvalUnit parse(Ruby runtime, InputStream istream, String filename2, int lineNumber) {
        return this.adapter.parse(runtime, istream, filename2, lineNumber);
    }
}

