/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.ModelManager;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.UnsupportedMarkupException;

public abstract class ModelManagerFactory<S extends ModelManager<?>>
implements Serializable {
    private Class<S> serviceClazz = null;
    private transient ListMultimap<Class<? extends Model>, Class<? extends S>> serviceProviderClazzes = null;

    protected ModelManagerFactory(Class<S> serviceClazz) {
        this.setServiceClass(serviceClazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public S newModelManager(PMML pmml, Model model) {
        Objects.requireNonNull(pmml);
        Objects.requireNonNull(model);
        try {
            List<Class<S>> modelManagerClasses = this.getServiceProviderClasses(model.getClass());
            for (Class<S> modelManagerClazz : modelManagerClasses) {
                Constructor<S> constructor = ModelManagerFactory.findConstructor(modelManagerClazz);
                try {
                    return (S)((ModelManager)constructor.newInstance(pmml, model));
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause instanceof UnsupportedMarkupException) continue;
                    throw ite;
                    throw new UnsupportedElementException((PMMLObject)model);
                }
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<Class<? extends S>> getServiceProviderClasses(Class<? extends Model> modelClazz) throws ClassNotFoundException, IOException {
        ListMultimap<Class<Model>, Class<S>> serviceProviderClazzes = this.getServiceProviderClasses();
        while (modelClazz != null) {
            List modelServiceProviderClazzes = serviceProviderClazzes.get(modelClazz);
            if (modelServiceProviderClazzes != null && !modelServiceProviderClazzes.isEmpty()) {
                return modelServiceProviderClazzes;
            }
            Class<? extends Model> modelSuperClazz = modelClazz.getSuperclass();
            if (!Model.class.isAssignableFrom(modelSuperClazz)) break;
            modelClazz = modelSuperClazz.asSubclass(Model.class);
        }
        return Collections.emptyList();
    }

    public Class<S> getServiceClass() {
        return this.serviceClazz;
    }

    private void setServiceClass(Class<S> serviceClazz) {
        this.serviceClazz = serviceClazz;
    }

    public ListMultimap<Class<? extends Model>, Class<? extends S>> getServiceProviderClasses() throws ClassNotFoundException, IOException {
        if (this.serviceProviderClazzes == null) {
            Class<S> serviceClazz = this.getServiceClass();
            this.serviceProviderClazzes = ModelManagerFactory.loadServiceProviderClasses(serviceClazz);
        }
        return this.serviceProviderClazzes;
    }

    private static <S extends ModelManager<?>> ListMultimap<Class<? extends Model>, Class<? extends S>> loadServiceProviderClasses(Class<S> serviceClazz) throws ClassNotFoundException, IOException {
        Thread thread = Thread.currentThread();
        ClassLoader clazzLoader = thread.getContextClassLoader();
        if (clazzLoader == null) {
            clazzLoader = ClassLoader.getSystemClassLoader();
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        Enumeration<URL> urls = clazzLoader.getResources("META-INF/services/" + serviceClazz.getName());
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            Throwable throwable = null;
            try {
                List<Class<S>> serviceProviderClazzes = ModelManagerFactory.loadServiceProviderClasses(is, clazzLoader, serviceClazz);
                for (Class<S> serviceProviderClazz : serviceProviderClazzes) {
                    Class<Model> modelClazz = ModelManagerFactory.findModelParameter(serviceClazz, serviceProviderClazz);
                    result.put(modelClazz, serviceProviderClazz);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return result;
    }

    private static <S> List<Class<? extends S>> loadServiceProviderClasses(InputStream is, ClassLoader clazzLoader, Class<S> serviceClazz) throws ClassNotFoundException, IOException {
        String line;
        ArrayList<Class<S>> result = new ArrayList<Class<S>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"), 1024);
        while ((line = reader.readLine()) != null) {
            int hash = line.indexOf(35);
            if (hash > -1) {
                line = line.substring(0, hash);
            }
            if ((line = line.trim()).isEmpty()) continue;
            Class<?> serviceProviderClazz = Class.forName(line, false, clazzLoader);
            if (!serviceClazz.isAssignableFrom(serviceProviderClazz)) {
                throw new IllegalArgumentException(line);
            }
            result.add(serviceProviderClazz);
        }
        reader.close();
        return result;
    }

    private static Constructor<?> findConstructor(Class<?> serviceProviderClass) throws NoSuchMethodException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = serviceProviderClass.getConstructors()) {
            Parameter[] parameters = constructor.getParameters();
            if (parameters.length != 2) continue;
            Parameter pmmlParameter = parameters[0];
            Parameter modelParameter = parameters[1];
            if (!PMML.class.isAssignableFrom(pmmlParameter.getType()) || !Model.class.isAssignableFrom(modelParameter.getType())) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }

    private static Class<? extends Model> findModelParameter(Class<?> serviceClazz, Class<?> serviceProviderClazz) {
        Class<?> clazz = serviceProviderClazz;
        while (clazz != null) {
            Class<?> superClazz = clazz.getSuperclass();
            if (serviceClazz.equals(superClazz)) {
                ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
                Type[] arguments = parameterizedType.getActualTypeArguments();
                if (arguments.length != 1) {
                    throw new IllegalArgumentException(clazz.getName());
                }
                Class argumentClazz = (Class)arguments[0];
                return argumentClazz.asSubclass(Model.class);
            }
            clazz = superClazz;
        }
        throw new IllegalArgumentException(serviceProviderClazz.getName());
    }
}

