/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.HasType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.HasValueSet;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.CategoricalValue;
import org.jpmml.evaluator.ContinuousValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.OrdinalValue;
import org.jpmml.evaluator.SetHolder;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.ToStringHelper;
import org.jpmml.model.XPathUtil;

public abstract class FieldValue
implements TypeInfo,
Serializable {
    private DataType dataType = null;
    private Object value = null;
    static final Integer STATUS_UNKNOWN_VALID = Integer.MAX_VALUE;
    static final Integer STATUS_MISSING = 0;
    static final Integer STATUS_UNKNOWN_INVALID = Integer.MIN_VALUE;

    FieldValue(DataType dataType, Object value) {
        this.setDataType(Objects.requireNonNull(dataType));
        this.setValue(Objects.requireNonNull(value));
    }

    public abstract boolean isValid();

    public abstract int compareToValue(Object var1);

    public abstract int compareToValue(FieldValue var1);

    public FieldValue cast(HasType<?> hasType) {
        DataType dataType = hasType.getDataType();
        OpType opType = hasType.getOpType();
        boolean equal = true;
        if (dataType == null) {
            dataType = this.getDataType();
        } else {
            equal &= this.getDataType().equals((Object)dataType);
        }
        if (opType == null) {
            opType = this.getOpType();
        } else {
            equal &= this.getOpType().equals((Object)opType);
        }
        if (equal) {
            return this;
        }
        return FieldValue.create(dataType, opType, this.getValue());
    }

    public FieldValue cast(TypeInfo typeInfo) {
        DataType dataType = typeInfo.getDataType();
        OpType opType = typeInfo.getOpType();
        if (this.getDataType().equals((Object)dataType) && this.getOpType().equals((Object)opType)) {
            return this;
        }
        return FieldValue.create(typeInfo, this.getValue());
    }

    public int compareTo(HasValue<?> hasValue) {
        return this.compareToValue(FieldValue.ensureValue(hasValue));
    }

    public boolean equals(HasValue<?> hasValue) {
        return this.equalsValue(FieldValue.ensureValue(hasValue));
    }

    public boolean isIn(HasValueSet<?> hasValueSet) {
        Array array = hasValueSet.getArray();
        if (array == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(hasValueSet.getClass()) + "/" + XPathUtil.formatElement(Array.class)), (PMMLObject)hasValueSet);
        }
        if (array instanceof SetHolder) {
            SetHolder setHolder = (SetHolder)array;
            return setHolder.contains(this.getDataType(), this.getValue());
        }
        List<?> values = ArrayUtil.getContent(array);
        return values.stream().anyMatch(value -> this.equalsValue(value));
    }

    public boolean isIn(Collection<FieldValue> values) {
        Predicate<FieldValue> predicate = new Predicate<FieldValue>(){

            @Override
            public boolean test(FieldValue value) {
                if (FieldValueUtil.isMissing(value)) {
                    return false;
                }
                return FieldValue.this.equalsValue(value);
            }
        };
        return values.stream().anyMatch(predicate);
    }

    public boolean equalsValue(Object value) {
        value = TypeUtil.parseOrCast(this.getDataType(), value);
        return this.getValue().equals(value);
    }

    public boolean equalsValue(FieldValue value) {
        return this.equalsValue(value.getValue());
    }

    public Collection<?> asCollection() {
        return TypeUtil.cast(Collection.class, this.getValue());
    }

    public String asString() {
        return (String)this.getValue(DataType.STRING);
    }

    public Number asNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        return (Number)this.getValue(DataType.DOUBLE);
    }

    public Integer asInteger() {
        return (Integer)this.getValue(DataType.INTEGER);
    }

    public Float asFloat() {
        Number number = this.asNumber();
        return Float.valueOf(number.floatValue());
    }

    public Double asDouble() {
        Number number = this.asNumber();
        return number.doubleValue();
    }

    public Boolean asBoolean() {
        return (Boolean)this.getValue(DataType.BOOLEAN);
    }

    public LocalDateTime asLocalDateTime() {
        return (LocalDateTime)this.getValue(DataType.DATE_TIME);
    }

    public LocalDate asLocalDate() {
        return (LocalDate)this.getValue(DataType.DATE);
    }

    public LocalTime asLocalTime() {
        return (LocalTime)this.getValue(DataType.TIME);
    }

    public ZonedDateTime asZonedDateTime(ZoneId zoneId) {
        try {
            LocalDateTime dateTime = this.asLocalDateTime();
            return dateTime.atZone(zoneId);
        }
        catch (TypeCheckException tceDateTime) {
            try {
                LocalDate localDate = this.asLocalDate();
                LocalTime localTime = LocalTime.MIDNIGHT;
                return ZonedDateTime.of(localDate, localTime, zoneId);
            }
            catch (TypeCheckException localDate) {
                try {
                    LocalDate localDate2 = LocalDate.now();
                    LocalTime localTime = this.asLocalTime();
                    return ZonedDateTime.of(localDate2, localTime, zoneId);
                }
                catch (TypeCheckException typeCheckException) {
                    throw tceDateTime;
                }
            }
        }
    }

    Object getValue(DataType dataType) {
        if (this.getDataType().equals((Object)dataType)) {
            return this.getValue();
        }
        return TypeUtil.parseOrCast(dataType, this.getValue());
    }

    public int hashCode() {
        return 31 * (this.getOpType().hashCode() ^ this.getDataType().hashCode()) + this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FieldValue) {
            FieldValue that = (FieldValue)object;
            return this.getOpType().equals((Object)that.getOpType()) && this.getDataType().equals((Object)that.getDataType()) && this.getValue().equals(that.getValue());
        }
        return false;
    }

    public String toString() {
        ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = new ToStringHelper((Object)this).add("opType", (Object)this.getOpType()).add("dataType", (Object)this.getDataType()).add("valid", (Object)this.isValid()).add("value", this.getValue());
        return helper;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        this.value = value;
    }

    public static FieldValue create(DataType dataType, OpType opType, Object value) {
        if (dataType == null || opType == null) {
            throw new IllegalArgumentException();
        }
        switch (opType) {
            case CONTINUOUS: {
                return ContinuousValue.create(dataType, value);
            }
            case CATEGORICAL: {
                return CategoricalValue.create(dataType, value);
            }
            case ORDINAL: {
                return OrdinalValue.create(dataType, (List)null, value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static FieldValue create(TypeInfo typeInfo, Object value) {
        if (typeInfo == null) {
            throw new IllegalArgumentException();
        }
        DataType dataType = typeInfo.getDataType();
        OpType opType = typeInfo.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                return ContinuousValue.create(dataType, value);
            }
            case CATEGORICAL: {
                return CategoricalValue.create(dataType, value);
            }
            case ORDINAL: {
                List<?> ordering = typeInfo.getOrdering();
                return OrdinalValue.create(dataType, ordering, value);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Object ensureValue(HasValue<?> hasValue) {
        Object value = hasValue.getValue();
        if (value == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(hasValue.getClass()) + "@value"), (PMMLObject)hasValue);
        }
        return value;
    }
}

