/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.DataType;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PoissonDistribution;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedElementException;

public class DistributionUtil {
    private DistributionUtil() {
    }

    public static double probability(ContinuousDistribution distribution, Number x) {
        if (distribution instanceof GaussianDistribution) {
            return DistributionUtil.probability((GaussianDistribution)distribution, x);
        }
        if (distribution instanceof PoissonDistribution) {
            return DistributionUtil.probability((PoissonDistribution)distribution, x);
        }
        throw new UnsupportedElementException((PMMLObject)distribution);
    }

    public static double probability(GaussianDistribution gaussianDistribution, Number x) {
        Number mean = gaussianDistribution.getMean();
        if (mean == null) {
            throw new MissingAttributeException((PMMLObject)gaussianDistribution, PMMLAttributes.GAUSSIANDISTRIBUTION_MEAN);
        }
        Number variance = gaussianDistribution.getVariance();
        if (variance == null) {
            throw new MissingAttributeException((PMMLObject)gaussianDistribution, PMMLAttributes.GAUSSIANDISTRIBUTION_VARIANCE);
        }
        if (variance.doubleValue() <= 0.0) {
            throw new InvalidAttributeException((PMMLObject)gaussianDistribution, PMMLAttributes.GAUSSIANDISTRIBUTION_VARIANCE, variance);
        }
        NormalDistribution distribution = new NormalDistribution(mean.doubleValue(), Math.sqrt(variance.doubleValue()));
        return distribution.density(x.doubleValue());
    }

    public static double probability(PoissonDistribution poissonDistribution, Number x) {
        Number mean = poissonDistribution.getMean();
        if (mean == null) {
            throw new MissingAttributeException((PMMLObject)poissonDistribution, PMMLAttributes.POISSONDISTRIBUTION_MEAN);
        }
        org.apache.commons.math3.distribution.PoissonDistribution distribution = new org.apache.commons.math3.distribution.PoissonDistribution(null, mean.doubleValue(), 1.0E-12, 10000000);
        x = (Number)TypeUtil.cast(DataType.INTEGER, (Object)x);
        return distribution.probability(x.intValue());
    }
}

