/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.Array;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.Strings;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class ArrayUtil {
    private static final LoadingCache<Array, List<?>> contentCache = CacheUtil.buildLoadingCache(new CacheLoader<Array, List<?>>(){

        public List<?> load(Array array) {
            return ImmutableList.copyOf(ArrayUtil.parse(array));
        }
    });

    private ArrayUtil() {
    }

    public static int getSize(Array array) {
        Integer n = array.getN();
        if (n != null) {
            return n;
        }
        List<?> content = ArrayUtil.getContent(array);
        return content.size();
    }

    public static List<?> getContent(Array array) {
        return CacheUtil.getValue(array, contentCache);
    }

    public static List<? extends Number> asNumberList(Array array) {
        List<?> content = ArrayUtil.getContent(array);
        Array.Type type = array.getType();
        if (type == null) {
            throw new MissingAttributeException((PMMLObject)array, PMMLAttributes.ARRAY_TYPE);
        }
        switch (type) {
            case INT: 
            case REAL: {
                return content;
            }
            case STRING: {
                throw new InvalidElementException((PMMLObject)array);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)array, (Enum<?>)type);
    }

    public static List<?> parse(Array array) {
        List tokens;
        Array.Type type = array.getType();
        if (type == null) {
            throw new MissingAttributeException((PMMLObject)array, PMMLAttributes.ARRAY_TYPE);
        }
        Object value = array.getValue();
        if (value instanceof String) {
            String string = (String)value;
            switch (type) {
                case INT: 
                case REAL: 
                case STRING: {
                    tokens = org.jpmml.model.ArrayUtil.parse((Array.Type)type, (String)string);
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)array, (Enum<?>)type);
                }
            }
        } else if (value instanceof List) {
            List list = (List)value;
            tokens = Lists.transform((List)list, TypeUtil::format);
        } else if (value instanceof Set) {
            Set set = (Set)value;
            tokens = set.stream().map(TypeUtil::format).collect(Collectors.toList());
        } else {
            throw new InvalidElementException((PMMLObject)array);
        }
        Integer n = array.getN();
        if (n != null && n.intValue() != tokens.size()) {
            throw new InvalidElementException((PMMLObject)array);
        }
        switch (type) {
            case INT: {
                return Lists.transform(tokens, token -> (Integer)Numbers.INTEGER_INTERNER.intern((Object)Integer.parseInt(token)));
            }
            case REAL: {
                return Lists.transform(tokens, token -> (Double)Numbers.DOUBLE_INTERNER.intern((Object)Double.parseDouble(token)));
            }
            case STRING: {
                return Lists.transform(tokens, token -> (String)Strings.INTERNER.intern(token));
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)array, (Enum<?>)type);
    }
}

