/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.notif.sse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jolokia.server.core.http.BackChannel;
import org.jolokia.server.core.util.DaemonThreadFactory;

class SseHeartBeat
implements Runnable {
    private static final byte[] COMMENT_FIELD = ": ".getBytes(StandardCharsets.UTF_8);
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("jolokia-sse-hearbeat"));
    private final BackChannel backChannel;
    private final int heartBeatPeriod = 10;
    private Future<?> heartBeat;

    public SseHeartBeat(BackChannel pBackChannel) {
        this.backChannel = pBackChannel;
    }

    void start() {
        this.scheduleHeartBeat();
    }

    public void stop() {
        if (this.heartBeat != null) {
            this.heartBeat.cancel(true);
            this.scheduler.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleHeartBeat() {
        BackChannel backChannel = this.backChannel;
        synchronized (backChannel) {
            if (!this.backChannel.isClosed()) {
                this.heartBeat = this.scheduler.schedule(this, 10L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BackChannel backChannel = this.backChannel;
            synchronized (backChannel) {
                OutputStream outputStream = this.backChannel.getOutputStream();
                outputStream.write(COMMENT_FIELD);
                outputStream.write(13);
                outputStream.flush();
                outputStream.write(10);
                outputStream.flush();
            }
            this.scheduleHeartBeat();
        }
        catch (IOException exp) {
            this.backChannel.close();
        }
    }
}

