/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.wrapper;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jodd.servlet.wrapper.Buffer;
import jodd.servlet.wrapper.ContentTypeHeaderResolver;
import jodd.servlet.wrapper.LastModifiedData;
import jodd.util.CharUtil;

public class BufferResponseWrapper
extends HttpServletResponseWrapper {
    protected static final String CONTENT_TYPE = "content-type";
    protected static final String CONTENT_LENGTH = "content-length";
    protected static final String LAST_MODIFIED = "last-modified";
    protected final LastModifiedData lastModifiedData;
    protected Buffer buffer;
    protected ContentTypeHeaderResolver contentTypeResolver;

    public BufferResponseWrapper(HttpServletResponse originalResponse) {
        this(originalResponse, new LastModifiedData());
    }

    public BufferResponseWrapper(HttpServletResponse originalResponse, LastModifiedData lastModifiedData) {
        super(originalResponse);
        this.lastModifiedData = lastModifiedData;
        lastModifiedData.startNewResponse();
        this.enableBuffering();
    }

    protected void preResponseCommit() {
    }

    public void commitResponse() {
        if (!this.getResponse().isCommitted()) {
            this.preResponseCommit();
        }
    }

    protected void enableBuffering() {
        if (this.buffer != null) {
            return;
        }
        this.buffer = new Buffer();
    }

    protected void disableBuffering() {
        if (this.buffer == null) {
            return;
        }
        this.buffer = null;
    }

    public boolean isBufferingEnabled() {
        return this.buffer != null;
    }

    public boolean isBufferStreamBased() {
        return this.buffer != null && this.buffer.isUsingStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.preResponseCommit();
        if (this.buffer == null) {
            return this.getResponse().getWriter();
        }
        return this.buffer.getWriter();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.preResponseCommit();
        if (this.buffer == null) {
            return this.getResponse().getOutputStream();
        }
        return this.buffer.getOutputStream();
    }

    public LastModifiedData getLastModifiedData() {
        return this.lastModifiedData;
    }

    public char[] getBufferedChars() {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toCharArray();
    }

    public byte[] getBufferedBytes() {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toByteArray();
    }

    public char[] getBufferContentAsChars() {
        if (this.buffer == null) {
            return null;
        }
        if (!this.buffer.isUsingStream()) {
            return this.buffer.toCharArray();
        }
        byte[] content = this.buffer.toByteArray();
        String encoding = this.getContentTypeEncoding();
        if (encoding == null) {
            return CharUtil.toCharArray(content);
        }
        return CharUtil.toCharArray(content, encoding);
    }

    public byte[] getBufferContentAsBytes() {
        if (this.buffer == null) {
            return null;
        }
        if (this.buffer.isUsingStream()) {
            return this.buffer.toByteArray();
        }
        char[] content = this.buffer.toCharArray();
        String encoding = this.getContentTypeEncoding();
        if (encoding == null) {
            return CharUtil.toByteArray(content);
        }
        return CharUtil.toByteArray(content, encoding);
    }

    public void writeContentToResponse(char[] content) throws IOException {
        if (this.buffer == null) {
            return;
        }
        if (this.buffer.isUsingStream()) {
            ServletOutputStream outputStream = this.getResponse().getOutputStream();
            String encoding = this.getContentTypeEncoding();
            if (encoding == null) {
                outputStream.write(CharUtil.toByteArray(content));
            } else {
                outputStream.write(CharUtil.toByteArray(content, encoding));
            }
            outputStream.flush();
        } else {
            PrintWriter out = this.getResponse().getWriter();
            ((Writer)out).write(content);
            ((Writer)out).flush();
        }
    }

    public void writeContentToResponse() throws IOException {
        if (this.buffer == null) {
            return;
        }
        if (this.buffer.isUsingStream()) {
            ServletOutputStream outputStream = this.getResponse().getOutputStream();
            outputStream.write(this.buffer.toByteArray());
            outputStream.flush();
        } else {
            PrintWriter out = this.getResponse().getWriter();
            ((Writer)out).write(this.buffer.toCharArray());
            ((Writer)out).flush();
        }
    }

    public String getContentTypeEncoding() {
        if (this.contentTypeResolver == null) {
            return null;
        }
        return this.contentTypeResolver.getEncoding();
    }

    public String getContentMimeType() {
        if (this.contentTypeResolver == null) {
            return null;
        }
        return this.contentTypeResolver.getMimeType();
    }

    protected boolean bufferContentType(String contentType, String mimeType, String encoding) {
        return true;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentTypeResolver = new ContentTypeHeaderResolver(type);
        if (this.bufferContentType(type, this.contentTypeResolver.getMimeType(), this.contentTypeResolver.getEncoding())) {
            this.enableBuffering();
        } else {
            this.disableBuffering();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.buffer == null) {
            super.flushBuffer();
        }
    }

    public void setContentLength(int contentLength) {
        if (this.buffer == null) {
            super.setContentLength(contentLength);
        }
    }

    public void setHeader(String name, String value) {
        String lowerName = name.toLowerCase();
        if (lowerName.equals(CONTENT_TYPE)) {
            this.setContentType(value);
        } else if (this.buffer == null || !lowerName.equals(CONTENT_LENGTH)) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        String lowerName = name.toLowerCase();
        if (lowerName.equals(CONTENT_TYPE)) {
            this.setContentType(value);
        } else if (this.buffer == null || !lowerName.equals(CONTENT_LENGTH)) {
            super.addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.buffer == null || !name.equalsIgnoreCase(CONTENT_LENGTH)) {
            super.setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.buffer == null || !name.equalsIgnoreCase(CONTENT_LENGTH)) {
            super.addIntHeader(name, value);
        }
    }

    public void setDateHeader(String name, long value) {
        if (name.equalsIgnoreCase(LAST_MODIFIED)) {
            this.lastModifiedData.updateLastModified(value);
        } else {
            super.setDateHeader(name, value);
        }
    }

    public void addDateHeader(String name, long value) {
        if (name.equalsIgnoreCase(LAST_MODIFIED)) {
            this.lastModifiedData.updateLastModified(value);
        } else {
            super.addDateHeader(name, value);
        }
    }

    public void setStatus(int statusCode) {
        this.stopBufferingForStatusCode(statusCode);
        super.setStatus(statusCode);
    }

    public void setStatus(int statusCode, String reason) {
        this.stopBufferingForStatusCode(statusCode);
        super.setStatus(statusCode);
    }

    public void sendError(int statusCode) throws IOException {
        this.stopBufferingForStatusCode(statusCode);
        super.sendError(statusCode);
    }

    public void sendError(int statusCode, String reason) throws IOException {
        this.stopBufferingForStatusCode(statusCode);
        super.sendError(statusCode, reason);
    }

    public void sendRedirect(String location) throws IOException {
        this.stopBufferingForStatusCode(307);
        super.sendRedirect(location);
    }

    protected void stopBufferingForStatusCode(int statusCode) {
        if (!this.bufferStatusCode(statusCode)) {
            this.disableBuffering();
        }
    }

    protected boolean bufferStatusCode(int statusCode) {
        return statusCode == 200;
    }

    public void print(String string) throws IOException {
        if (this.isBufferStreamBased()) {
            String encoding = this.getContentTypeEncoding();
            byte[] bytes = encoding == null ? string.getBytes() : string.getBytes(encoding);
            this.buffer.getOutputStream().write(bytes);
            return;
        }
        this.buffer.getWriter().write(string);
    }
}

