/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.def;

import java.util.Objects;

public class BeanReferences {
    private final String[] names;

    public static BeanReferences of(String ... names) {
        Objects.requireNonNull(names);
        return new BeanReferences(names);
    }

    BeanReferences(String ... names) {
        this.names = names;
    }

    public boolean isEmpty() {
        return this.names.length == 0;
    }

    public int size() {
        return this.names.length;
    }

    public String name(int ndx) {
        return this.names[ndx];
    }

    public BeanReferences removeDuplicateNames() {
        if (this.names.length < 2) {
            return this;
        }
        int nullCount = 0;
        block0: for (int i = 1; i < this.names.length; ++i) {
            String thisRef = this.names[i];
            if (thisRef == null) {
                ++nullCount;
                continue;
            }
            for (int j = 0; j < i; ++j) {
                if (this.names[j] == null || !thisRef.equals(this.names[j])) continue;
                this.names[i] = null;
                continue block0;
            }
        }
        if (nullCount == 0) {
            return this;
        }
        String[] newRefs = new String[this.names.length - nullCount];
        int ndx = 0;
        for (String name : this.names) {
            if (name == null) continue;
            newRefs[ndx] = name;
            ++ndx;
        }
        return new BeanReferences(newRefs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.names.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.names[i]);
        }
        sb.append(']');
        return sb.toString();
    }
}

