/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.petite.def.ValueInjectionPoint;
import jodd.petite.meta.PetiteValue;
import jodd.template.ContextTemplateParser;
import jodd.template.MapTemplateParser;
import jodd.util.PropertiesUtil;
import jodd.util.StringPool;

public class ParamManager {
    protected final Map<String, Object> params = new HashMap<String, Object>();
    protected final ContextTemplateParser contextTemplateParser = new MapTemplateParser().of(this.params);

    public void put(String name, Object value) {
        this.params.put(name, value);
    }

    public Object get(String name) {
        return this.params.get(name);
    }

    public String parseKeyTemplate(String input) {
        return this.contextTemplateParser.parse(input);
    }

    public String[] filterParametersForBeanName(String beanName, boolean resolveReferenceParams) {
        beanName = beanName + '.';
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(beanName)) continue;
            list.add(key);
            if (!resolveReferenceParams) continue;
            String value = PropertiesUtil.resolveProperty(this.params, key);
            entry.setValue(value);
        }
        if (list.isEmpty()) {
            return StringPool.EMPTY_ARRAY;
        }
        return list.toArray(new String[0]);
    }

    public ValueInjectionPoint[] resolveParamInjectionPoints(Class type) {
        ClassDescriptor cd = ClassIntrospector.get().lookup(type);
        ArrayList<ValueInjectionPoint> valueInjectionPointList = new ArrayList<ValueInjectionPoint>();
        for (PropertyDescriptor pd : cd.getAllPropertyDescriptors()) {
            PetiteValue petiteValue;
            PetiteValue petiteValue2;
            FieldDescriptor fd = pd.getFieldDescriptor();
            if (fd != null && (petiteValue2 = fd.getField().getAnnotation(PetiteValue.class)) != null) {
                valueInjectionPointList.add(new ValueInjectionPoint(pd.getName(), petiteValue2.value()));
                continue;
            }
            MethodDescriptor md = pd.getWriteMethodDescriptor();
            if (md == null || (petiteValue = md.getMethod().getAnnotation(PetiteValue.class)) == null) continue;
            valueInjectionPointList.add(new ValueInjectionPoint(pd.getName(), petiteValue.value()));
        }
        return valueInjectionPointList.toArray(new ValueInjectionPoint[0]);
    }
}

