/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import jodd.mail.MailServer;
import jodd.mail.SmtpServer;

public class SmtpSslServer
extends SmtpServer {
    protected static final int DEFAULT_SSL_PORT = 465;
    protected boolean startTlsRequired = false;
    protected boolean plaintextOverTLS = false;

    public SmtpSslServer(MailServer.Builder builder) {
        super(builder, 465);
    }

    public SmtpSslServer startTlsRequired(boolean startTlsRequired) {
        this.startTlsRequired = startTlsRequired;
        return this;
    }

    public SmtpSslServer plaintextOverTLS(boolean plaintextOverTLS) {
        this.plaintextOverTLS = plaintextOverTLS;
        return this;
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty("mail.smtp.starttls.required", this.startTlsRequired ? "true" : "false");
        props.setProperty("mail.smtp.starttls.enable", "true");
        props.setProperty("mail.smtp.socketFactory.port", String.valueOf(this.port));
        props.setProperty("mail.smtp.port", String.valueOf(this.port));
        if (!this.plaintextOverTLS) {
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.host", this.host);
        return props;
    }
}

