/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import jodd.mail.EmailAddress;

public class RFC2822AddressParser {
    private boolean ALLOW_DOMAIN_LITERALS = false;
    private boolean ALLOW_QUOTED_IDENTIFIERS = true;
    private boolean ALLOW_DOT_IN_ATEXT = false;
    private boolean EXTRACT_CFWS_PERSONAL_NAMES = true;
    private boolean ALLOW_SQUARE_BRACKETS_IN_ATEXT = false;
    private boolean ALLOW_PARENS_IN_LOCALPART = true;
    public static final RFC2822AddressParser STRICT = new RFC2822AddressParser().allowDomainLiterals(true).allowQuotedIdentifiers(true).allowDotInAtext(false).extractCfwsPersonalName(true).allowSquareBracketsInAtext(false).allowParentheseInLocalpart(true);
    public static final RFC2822AddressParser LOOSE = new RFC2822AddressParser();
    private Pattern _MAILBOX_PATTERN;
    private Pattern _RETURN_PATH_PATTERN;
    private Pattern _ADDR_SPEC_PATTERN;
    private Pattern _COMMENT_PATTERN;
    private Pattern _QUOTED_STRING_WO_CFWS_PATTERN;
    private static final Pattern ESCAPED_QUOTE_PATTERN = Pattern.compile("\\\\\"");
    private static final Pattern ESCAPED_BSLASH_PATTERN = Pattern.compile("\\\\\\\\");

    public RFC2822AddressParser allowDomainLiterals(boolean allow) {
        this.ALLOW_DOMAIN_LITERALS = allow;
        this.resetPatterns();
        return this;
    }

    public RFC2822AddressParser allowQuotedIdentifiers(boolean allow) {
        this.ALLOW_QUOTED_IDENTIFIERS = allow;
        this.resetPatterns();
        return this;
    }

    public RFC2822AddressParser allowDotInAtext(boolean allow) {
        this.ALLOW_DOT_IN_ATEXT = allow;
        this.resetPatterns();
        return this;
    }

    public RFC2822AddressParser extractCfwsPersonalName(boolean extract) {
        this.EXTRACT_CFWS_PERSONAL_NAMES = extract;
        this.resetPatterns();
        return this;
    }

    public RFC2822AddressParser allowSquareBracketsInAtext(boolean allow) {
        this.ALLOW_SQUARE_BRACKETS_IN_ATEXT = allow;
        this.resetPatterns();
        return this;
    }

    public RFC2822AddressParser allowParentheseInLocalpart(boolean allow) {
        this.ALLOW_PARENS_IN_LOCALPART = allow;
        this.resetPatterns();
        return this;
    }

    public ParsedAddress parse(String email) {
        email = email.trim();
        Matcher mailboxMatcher = this.MAILBOX_PATTERN().matcher(email);
        boolean mailboxMatcherMatches = mailboxMatcher.matches();
        String[] mailboxMatcherParts = mailboxMatcherMatches ? this._calcMatcherParts(mailboxMatcher) : null;
        Matcher returnPathMatcher = this.RETURN_PATH_PATTERN().matcher(email);
        boolean returnPathMatches = returnPathMatcher.matches();
        String personalName = null;
        String localPart = null;
        String domain = null;
        InternetAddress internetAddress = null;
        String returnPathAddress = null;
        if (mailboxMatcherMatches) {
            personalName = mailboxMatcherParts[0];
            localPart = mailboxMatcherParts[1];
            domain = mailboxMatcherParts[2];
            internetAddress = this.pullFromGroups(mailboxMatcher);
        }
        if (returnPathMatches) {
            returnPathAddress = internetAddress != null ? internetAddress.getAddress() : "";
        }
        return new ParsedAddress(mailboxMatcherMatches, personalName, localPart, domain, internetAddress, returnPathMatches, returnPathAddress);
    }

    public InternetAddress parseToInternetAddress(String email) {
        ParsedAddress parsedAddress = this.parse(email);
        if (!parsedAddress.isValid()) {
            return null;
        }
        return parsedAddress.getInternetAddress();
    }

    public EmailAddress parseToEmailAddress(String email) {
        ParsedAddress parsedAddress = this.parse(email);
        if (!parsedAddress.isValid()) {
            return null;
        }
        return new EmailAddress(parsedAddress.getPersonalName(), parsedAddress.getLocalPart() + '@' + parsedAddress.getDomain());
    }

    private Pattern MAILBOX_PATTERN() {
        if (this._MAILBOX_PATTERN == null) {
            this.buildPatterns();
        }
        return this._MAILBOX_PATTERN;
    }

    private Pattern RETURN_PATH_PATTERN() {
        if (this._RETURN_PATH_PATTERN == null) {
            this.buildPatterns();
        }
        return this._RETURN_PATH_PATTERN;
    }

    private void resetPatterns() {
        this._MAILBOX_PATTERN = null;
        this._RETURN_PATH_PATTERN = null;
    }

    private void buildPatterns() {
        String CRLF = "\\r\\n";
        String WSP = "[ \\t]";
        String FWSP = "(?:[ \\t]*\\r\\n)?[ \\t]+";
        String D_QUOTE = "\\\"";
        String NO_WS_CTL = "\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F";
        String ASCII_TEXT = "[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]";
        String QUOTED_PAIR = "(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
        String C_TEXT = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]";
        String C_CONTENT = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
        String COMMENT = "\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\)";
        String CFWS = "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))";
        String A_TEXT = "[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~" + (this.ALLOW_DOT_IN_ATEXT ? "\\." : "") + (this.ALLOW_SQUARE_BRACKETS_IN_ATEXT ? "\\[\\]" : "") + "]";
        String REGULAR_A_TEXT = "[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]";
        String ATOM = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?" + A_TEXT + "+(?:" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?";
        String DOT_ATOM_TEXT = "[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*";
        String CAP_DOT_ATOM_NO_CFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String CAP_DOT_ATOM_TRAILING_CFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String Q_TEXT = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]";
        String LOCAL_PART_Q_TEXT = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F" + (this.ALLOW_PARENS_IN_LOCALPART ? "\\!\\#-\\[\\]-\\~]" : "\\!\\#-\\'\\*-\\[\\]-\\~]");
        String Q_CONTENT = "(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))";
        String LOCAL_PART_Q_CONTENT = "(?>" + LOCAL_PART_Q_TEXT + "|" + "(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])" + ")";
        String QUOTED_STRING_WOCFWS = "\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"";
        String QUOTED_STRING = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String LOCAL_PART_QUOTED_STRING = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\\"(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?" + LOCAL_PART_Q_CONTENT + ")*(?:" + "(?:[ \\t]*\\r\\n)?[ \\t]+" + ")?" + "\\\"" + ")(?:" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?";
        String WORD = "(?:(?:" + ATOM + ")|(?:" + "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?" + "))";
        String PHRASE = WORD + "(?:(?:" + "(?:[ \\t]*\\r\\n)?[ \\t]+" + ")" + WORD + ")*";
        String LETTER = "[a-zA-Z]";
        String LET_DIG = "[a-zA-Z0-9]";
        String LET_DIG_HYP = "[a-zA-Z0-9-]";
        String RFC_LABEL = "[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?";
        String RFC_1035_DOMAIN_NAME = "[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\.[a-zA-Z]{2,6}";
        String D_TEXT = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]";
        String D_CONTENT = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])";
        String CAP_DOMAIN_LITERAL_NO_CFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String CAP_DOMAIN_LITERAL_TRAILING_CFWS = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String RFC_2822_DOMAIN = "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)";
        String CAP_CFWSR_FC2822_DOMAIN = "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)";
        String DOMAIN = this.ALLOW_DOMAIN_LITERALS ? "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)" : "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\.[a-zA-Z]{2,6})(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String CAP_CFWS_DOMAIN = this.ALLOW_DOMAIN_LITERALS ? "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?(\\[(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-Z\\^-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))+)*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\])((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?)" : "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\.[a-zA-Z]{2,6})((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?";
        String LOCAL_PART = "((?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?([a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+(?:\\.[a-zA-Z0-9\\!\\#-\\'\\*\\+\\-\\/\\=\\?\\^-\\`\\{-\\~]+)*)(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|" + LOCAL_PART_QUOTED_STRING + ")";
        String ADDR_SPEC = LOCAL_PART + "@" + DOMAIN;
        String UNIQUE_ADDR_SPEC = LOCAL_PART + "@" + CAP_CFWS_DOMAIN;
        String ANGLE_ADDR = "(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?<" + ADDR_SPEC + ">(" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?";
        String NAME_ADDR = "(" + PHRASE + ")??(" + ANGLE_ADDR + ")";
        String MAIL_BOX = (this.ALLOW_QUOTED_IDENTIFIERS ? "(" + NAME_ADDR + ")|" : "") + "(" + UNIQUE_ADDR_SPEC + ")";
        String RETURN_PATH = "(?:(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?<((?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+)))?|" + ADDR_SPEC + ")>(?:" + "(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))*(?:(?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\))|(?:(?:[ \\t]*\\r\\n)?[ \\t]+))" + ")?)";
        this._MAILBOX_PATTERN = Pattern.compile(MAIL_BOX);
        this._ADDR_SPEC_PATTERN = Pattern.compile(ADDR_SPEC);
        this._COMMENT_PATTERN = Pattern.compile("\\((?:(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!-\\'\\*-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F]))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\)");
        this._QUOTED_STRING_WO_CFWS_PATTERN = Pattern.compile("\\\"(?>(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F\\!\\#-\\[\\]-\\~]|(?:\\\\[\\x01-\\x09\\x0B\\x0C\\x0E-\\x7F])))*(?:(?:[ \\t]*\\r\\n)?[ \\t]+)?\\\"");
        this._RETURN_PATH_PATTERN = Pattern.compile(RETURN_PATH);
    }

    private InternetAddress pullFromGroups(Matcher m) {
        InternetAddress currentInternetAddress;
        String[] parts = this._calcMatcherParts(m);
        if (parts[1] == null || parts[2] == null) {
            return null;
        }
        try {
            currentInternetAddress = new InternetAddress();
            currentInternetAddress.setPersonal(parts[0]);
            currentInternetAddress.setAddress(parts[1] + "@" + parts[2]);
        }
        catch (UnsupportedEncodingException uee) {
            currentInternetAddress = null;
        }
        return currentInternetAddress;
    }

    private String[] _calcMatcherParts(Matcher m) {
        String testAddr;
        String currentLocalpart = null;
        String currentDomainpart = null;
        String localPartQs = null;
        String domainPartDl = null;
        String personalString = null;
        if (this.ALLOW_QUOTED_IDENTIFIERS) {
            if (this.ALLOW_DOMAIN_LITERALS) {
                if (m.group(1) != null) {
                    String domainPartDa;
                    String localPartDa = m.group(5);
                    if (localPartDa == null) {
                        localPartQs = m.group(6);
                    }
                    if ((domainPartDa = m.group(7)) == null) {
                        domainPartDl = m.group(8);
                    }
                    currentLocalpart = localPartDa == null ? localPartQs : localPartDa;
                    currentDomainpart = domainPartDa == null ? domainPartDl : domainPartDa;
                    personalString = m.group(2);
                    if (personalString == null && this.EXTRACT_CFWS_PERSONAL_NAMES) {
                        personalString = m.group(9);
                        personalString = RFC2822AddressParser.removeAnyBounding('(', ')', this.getFirstComment(personalString));
                    }
                } else if (m.group(10) != null) {
                    String domainPartDa;
                    String localPartDa = m.group(12);
                    if (localPartDa == null) {
                        localPartQs = m.group(13);
                    }
                    if ((domainPartDa = m.group(14)) == null) {
                        domainPartDl = m.group(15);
                    }
                    currentLocalpart = localPartDa == null ? localPartQs : localPartDa;
                    String string = currentDomainpart = domainPartDa == null ? domainPartDl : domainPartDa;
                    if (this.EXTRACT_CFWS_PERSONAL_NAMES) {
                        personalString = m.group(16);
                        personalString = RFC2822AddressParser.removeAnyBounding('(', ')', this.getFirstComment(personalString));
                    }
                }
            } else if (m.group(1) != null) {
                String localPartDa = m.group(5);
                if (localPartDa == null) {
                    localPartQs = m.group(6);
                }
                currentLocalpart = localPartDa == null ? localPartQs : localPartDa;
                currentDomainpart = m.group(7);
                personalString = m.group(2);
                if (personalString == null && this.EXTRACT_CFWS_PERSONAL_NAMES) {
                    personalString = m.group(8);
                    personalString = RFC2822AddressParser.removeAnyBounding('(', ')', this.getFirstComment(personalString));
                }
            } else if (m.group(9) != null) {
                String localPartDa = m.group(11);
                if (localPartDa == null) {
                    localPartQs = m.group(12);
                }
                currentLocalpart = localPartDa == null ? localPartQs : localPartDa;
                currentDomainpart = m.group(13);
                if (this.EXTRACT_CFWS_PERSONAL_NAMES) {
                    personalString = m.group(14);
                    personalString = RFC2822AddressParser.removeAnyBounding('(', ')', this.getFirstComment(personalString));
                }
            }
        } else {
            String domainPartDa;
            String localPartDa = m.group(3);
            if (localPartDa == null) {
                localPartQs = m.group(4);
            }
            if ((domainPartDa = m.group(5)) == null && this.ALLOW_DOMAIN_LITERALS) {
                domainPartDl = m.group(6);
            }
            currentLocalpart = localPartDa == null ? localPartQs : localPartDa;
            String string = currentDomainpart = domainPartDa == null ? domainPartDl : domainPartDa;
            if (this.EXTRACT_CFWS_PERSONAL_NAMES) {
                personalString = m.group((this.ALLOW_DOMAIN_LITERALS ? 1 : 0) + 6);
                personalString = RFC2822AddressParser.removeAnyBounding('(', ')', this.getFirstComment(personalString));
            }
        }
        if (currentLocalpart != null) {
            currentLocalpart = currentLocalpart.trim();
        }
        if (currentDomainpart != null) {
            currentDomainpart = currentDomainpart.trim();
        }
        if (personalString != null) {
            personalString = personalString.trim();
            personalString = this.cleanupPersonalString(personalString);
        }
        if (this._ADDR_SPEC_PATTERN.matcher(testAddr = RFC2822AddressParser.removeAnyBounding('\"', '\"', currentLocalpart) + "@" + currentDomainpart).matches()) {
            currentLocalpart = RFC2822AddressParser.removeAnyBounding('\"', '\"', currentLocalpart);
        }
        return new String[]{personalString, currentLocalpart, currentDomainpart};
    }

    private String getFirstComment(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = this._COMMENT_PATTERN.matcher(text);
        if (!m.find()) {
            return null;
        }
        return m.group().trim();
    }

    private String cleanupPersonalString(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = this._QUOTED_STRING_WO_CFWS_PATTERN.matcher(text = text.trim());
        if (!m.matches()) {
            return text;
        }
        text = RFC2822AddressParser.removeAnyBounding('\"', '\"', m.group());
        text = ESCAPED_BSLASH_PATTERN.matcher(text).replaceAll("\\\\");
        text = ESCAPED_QUOTE_PATTERN.matcher(text).replaceAll("\"");
        return text.trim();
    }

    private static String removeAnyBounding(char s, char e, String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        if (str.startsWith(String.valueOf(s)) && str.endsWith(String.valueOf(e))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static class ParsedAddress {
        private final boolean isValid;
        private final String personalName;
        private final String localPart;
        private final String domain;
        private final InternetAddress internetAddress;
        private final boolean validReturnPath;
        private final String returnPathAddress;

        private ParsedAddress(boolean isValid, String personalName, String localPart, String domain, InternetAddress internetAddress, boolean validReturnPath, String returnPathAddress) {
            this.isValid = isValid;
            this.personalName = personalName;
            this.internetAddress = internetAddress;
            this.domain = domain;
            this.localPart = localPart;
            this.validReturnPath = validReturnPath;
            this.returnPathAddress = returnPathAddress;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getPersonalName() {
            return this.personalName;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public String getDomain() {
            return this.domain;
        }

        public InternetAddress getInternetAddress() {
            return this.internetAddress;
        }

        public boolean isValidReturnPath() {
            return this.validReturnPath;
        }

        public String getReturnPathAddress() {
            return this.returnPathAddress;
        }
    }
}

