/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import jodd.mail.MailException;

abstract class EMLProperties<T extends EMLProperties<T>> {
    private Session session;
    private final Properties properties = new Properties();

    EMLProperties() {
    }

    protected T _this() {
        return (T)this;
    }

    protected Session getSession() {
        return this.session;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected Session createSession(Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        this.session = Session.getInstance((Properties)properties);
        return this.session;
    }

    public T set(Properties properties) throws MailException {
        this.checkSessionNotSet();
        this.properties.putAll((Map<?, ?>)properties);
        return this._this();
    }

    public T set(String name, String value) {
        this.checkSessionNotSet();
        this.properties.setProperty(name, value);
        return this._this();
    }

    public T useDefaultSession() {
        this.session = Session.getDefaultInstance((Properties)System.getProperties());
        return this._this();
    }

    private void checkSessionNotSet() throws MailException {
        if (this.session != null) {
            throw new MailException("Can't set properties after session is assigned");
        }
    }
}

